/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.initialization;

import com.gamedash.daemon.common.initialization.AbstractInitializer;
import com.gamedash.daemon.common.initialization.implementation.IInitializerImplementation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AsyncInitializer
extends AbstractInitializer {
    public AsyncInitializer(List<IInitializerImplementation> implementations) {
        super(implementations);
    }

    @Override
    public void initialize() throws Exception {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ExecutorService threadPool = Executors.newFixedThreadPool(this.getImplementations().size());
        for (IInitializerImplementation iInitializerImplementation : this.getImplementations()) {
            if (!iInitializerImplementation.isAvailable()) continue;
            futures.add(threadPool.submit(() -> {
                implementation.initialize();
                return null;
            }));
        }
        threadPool.shutdown();
        threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        for (Future future : futures) {
            if (future == null) continue;
            future.get();
        }
    }

    @Override
    public void destroy() throws Exception {
        for (IInitializerImplementation implementation : this.getImplementations()) {
            implementation.destroy();
        }
    }

    public static AsyncInitializer create(List<IInitializerImplementation> implementations) {
        return new AsyncInitializer(implementations);
    }
}

