/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.dataLayer;

import com.gamedash.daemon.common.dataLayer.IFetchFunction;
import com.gamedash.daemon.common.dataLayer.Store;
import com.gamedash.daemon.common.dataLayer.ValueSource;
import com.gamedash.daemon.common.dataLayer.ValueSourceNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractDataLayer {
    public Store store = new Store();
    private List<ValueSource> valueSources = new ArrayList<ValueSource>();

    public List<ValueSource> getValueSources() {
        return this.valueSources;
    }

    public ValueSource registerValueSource(String[] fetchableValues, IFetchFunction fetchFunction) {
        return this.registerValueSource(Arrays.asList(fetchableValues), fetchFunction);
    }

    public ValueSource registerValueSource(List<String> fetchableValues, IFetchFunction fetchFunction) {
        ValueSource valueSource = new ValueSource(fetchableValues, fetchFunction);
        this.valueSources.add(valueSource);
        return valueSource;
    }

    public synchronized Object getValue(String name) throws Exception {
        ValueSource valueSource = this.findValueSource(name);
        if (valueSource != null && valueSource.hasTimedOut()) {
            this.store.clearValueSource(valueSource);
        }
        if (this.store.valueExists(name)) {
            return this.store.getValue(name);
        }
        if (valueSource != null) {
            Object value = valueSource.fetch(name);
            this.store.setValue(name, value);
            return value;
        }
        throw new ValueSourceNotFoundException("Value source that supports getting value " + name + " not found");
    }

    public void setValue(String name, Object value) {
        if (!this.valueIsFetchable(name)) {
            throw new ValueSourceNotFoundException("No sources allow value " + name);
        }
        this.store.setValue(name, value);
    }

    public void clearValue(String name) {
        this.store.deleteValue(name);
    }

    public ValueSource findValueSource(String name) {
        for (ValueSource valueSource : this.getValueSources()) {
            if (!valueSource.valueIsFetchable(name)) continue;
            return valueSource;
        }
        return null;
    }

    public void clear() {
        this.store.clear();
    }

    public boolean valueIsFetchable(String name) {
        return true;
    }

    public Store getStore() {
        return this.store;
    }
}

