/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.server.request.input.parameter;

import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.request.input.parameter.transformer.IRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.input.parameter.transformer.StringRequestParameterTransformer;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RequestParameter {
    private final String name;
    private final String value;

    public RequestParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() throws RequestParameterException {
        return this.getValue(new StringRequestParameterTransformer());
    }

    public <T> T getValue(IRequestParameterTransformer<T> transformer) {
        return transformer.transform(this.value);
    }

    public Object getJsonArray(Type type) throws RequestParameterException {
        Gson gson = new Gson();
        return gson.fromJson(this.getValue(new StringRequestParameterTransformer()), type);
    }

    public <T> T getJsonArray(Class<T> classOf) throws RequestParameterException {
        Gson gson = new Gson();
        return gson.fromJson(this.getValue(new StringRequestParameterTransformer()), classOf);
    }

    public List<String> getList() {
        if (this.value.equals("")) {
            return new ArrayList<String>();
        }
        return Arrays.asList(this.value.split(","));
    }

    public List<Integer> getIntegerList() {
        return this.getLongList().stream().map(Math::toIntExact).collect(Collectors.toList());
    }

    public List<Long> getLongList() {
        ArrayList<Long> values = new ArrayList<Long>();
        for (String value : this.getList()) {
            try {
                values.add(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return values;
    }
}

