/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.server.exception;

import com.gamedash.daemon.common.api.server.ApiServer;
import com.gamedash.daemon.common.api.server.ApiServerException;
import com.gamedash.daemon.common.api.server.ErrorBody;
import com.google.gson.Gson;

public class ExceptionHandler<T extends Exception> {
    private static final Gson gson = new Gson();
    private final Class<T> type;
    private int httpStatusCode = 400;
    private String code;
    private ApiServer server;

    public ExceptionHandler(Class<T> type) {
        this.type = type;
    }

    public ExceptionHandler(ApiServer server, Class<T> type, int httpStatusCode) {
        this.server = server;
        this.type = type;
        this.httpStatusCode = httpStatusCode;
    }

    public ExceptionHandler(ApiServer server, Class<T> type, int httpStatusCode, String code) {
        this.server = server;
        this.type = type;
        this.httpStatusCode = httpStatusCode;
        this.code = code;
    }

    public void register() {
        this.server.getService().exception(this.type, (exception, request, response) -> {
            response.status(this.getHttpStatusCode());
            response.type("application/json");
            ErrorBody errorBody = new ErrorBody(exception.getMessage(), exception.getStackTrace());
            if (exception instanceof ApiServerException && ((ApiServerException)exception).hasCode()) {
                errorBody.setCode(((ApiServerException)exception).getCode());
            }
            response.body(gson.toJson(errorBody));
        });
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getCode() {
        return this.code;
    }
}

