/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.system.user.SystemUserNotFoundException;
import com.gamedash.daemon.system.user.SystemUsers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SetHomeDirectory
extends Route<String> {
    public SetHomeDirectory(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        String name = this.request.getInput().getParameters().get("name").getValue();
        if (!SystemUsers.exists(name)) {
            throw new SystemUserNotFoundException("User " + name + " does not exist");
        }
        File directory = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!directory.exists()) {
            throw new FileNotFoundException("Could not find directory");
        }
        if (!directory.isDirectory()) {
            throw new IOException("File must be a directory");
        }
        SystemUser systemUser = SystemUsers.get(this.request.getInput().getParameters().get("name").getValue());
        systemUser.setHomeDirectory(directory);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"name", "path"};
    }
}

