/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system.os.fileSystem.fileStore;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import oshi.SystemInfo;
import oshi.software.os.OSFileStore;

public class GetFileStores
extends Route<List<StoreResult>> {
    private final SystemInfo systemInfo = new SystemInfo();

    public GetFileStores(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<StoreResult> execute() throws Exception {
        ArrayList<StoreResult> results = new ArrayList<StoreResult>();
        for (OSFileStore store : this.systemInfo.getOperatingSystem().getFileSystem().getFileStores()) {
            StoreResult storeResult = new StoreResult();
            storeResult.name = store.getName();
            storeResult.uuid = store.getUUID();
            storeResult.freeInodes = store.getFreeInodes();
            storeResult.freeSpace = store.getFreeSpace();
            storeResult.totalSpace = store.getTotalSpace();
            storeResult.usableSpace = store.getUsableSpace();
            storeResult.logicalVolume = store.getLogicalVolume();
            storeResult.mount = store.getMount();
            results.add(storeResult);
        }
        return results;
    }

    static class StoreResult {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="uuid")
        public String uuid;
        @SerializedName(value="freeInodes")
        public long freeInodes;
        @SerializedName(value="freeSpace")
        public long freeSpace;
        @SerializedName(value="usableSpace")
        public long usableSpace;
        @SerializedName(value="totalSpace")
        public long totalSpace;
        @SerializedName(value="logicalVolume")
        public String logicalVolume;
        @SerializedName(value="mount")
        public String mount;

        StoreResult() {
        }
    }
}

