/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.container;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.DockerContainerHostConfig;
import com.gamedash.daemon.docker.container.DockerContainerMount;
import com.gamedash.daemon.docker.container.DockerContainerNetwork;
import com.gamedash.daemon.docker.container.DockerContainerPort;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GetRunningContainers
extends Route<List<?>> {
    private Docker docker = Docker.getInstance();

    public GetRunningContainers(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<ContainerResult> execute() throws Exception {
        ArrayList<ContainerResult> results = new ArrayList<ContainerResult>();
        for (DockerContainer dockerContainer : this.docker.getContainers().getRunning()) {
            results.add(new ContainerResult(dockerContainer));
        }
        return results;
    }

    private static class ContainerResult {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="names")
        private String[] names;
        @SerializedName(value="image")
        private String image;
        @SerializedName(value="imageId")
        private String imageId;
        private Map<String, String> labels;
        private Long rootSize;
        private HostConfig hostConfig;
        private List<Mount> mounts = new ArrayList<Mount>();
        private List<Network> networks = new ArrayList<Network>();
        @SerializedName(value="ports")
        private List<Port> ports = new ArrayList<Port>();

        public ContainerResult(DockerContainer container) {
            this.id = container.getId();
            this.image = container.getImage();
            this.imageId = container.getImageId();
            container.getPorts().forEach(port -> this.ports.add(new Port((DockerContainerPort)port)));
            container.getMounts().forEach(mount -> this.mounts.add(new Mount((DockerContainerMount)mount)));
            container.getNetworks().forEach(network -> this.networks.add(new Network((DockerContainerNetwork)network)));
        }

        private static class Port {
            @SerializedName(value="ip")
            private String ip;
            @SerializedName(value="privateIp")
            private Integer privateIp;
            @SerializedName(value="publicIp")
            private Integer publicIp;
            @SerializedName(value="type")
            private String type;

            public Port(DockerContainerPort port) {
                this.ip = port.getIp();
                this.privateIp = port.getPrivatePort();
                this.publicIp = port.getPublicPort();
                this.type = port.getType();
            }
        }

        private static class Network {
            @SerializedName(value="propagation")
            private List<String> aliases;
            @SerializedName(value="endpointId")
            private String endpointId;
            @SerializedName(value="gateway")
            private String gateway;
            @SerializedName(value="ipAddress")
            private String ipAddress;
            @SerializedName(value="ipPrefixingLen")
            private Integer ipPrefixingLen;
            @SerializedName(value="ipV6Gateway")
            private String ipV6Gateway;
            @SerializedName(value="globalIpV6Address")
            private String globalIpV6Address;
            @SerializedName(value="globalIpv6PrefixingLen")
            private Integer globalIpv6PrefixingLen;
            @SerializedName(value="macAddress")
            private String macAddress;

            public Network(DockerContainerNetwork network) {
                this.aliases = network.getAliases();
                this.endpointId = network.getEndpointId();
                this.gateway = network.getGateway();
                this.ipAddress = network.getIpAddress();
                this.ipPrefixingLen = network.getIpPrefixingLen();
                this.ipV6Gateway = network.getIpV6Gateway();
                this.globalIpV6Address = network.getGlobalIpV6Address();
                this.globalIpv6PrefixingLen = network.getGlobalIpv6PrefixingLen();
                this.macAddress = network.getMacAddress();
            }
        }

        private static class Mount {
            @SerializedName(value="name")
            private String name;
            @SerializedName(value="source")
            private String source;
            @SerializedName(value="destination")
            private String destination;
            @SerializedName(value="driver")
            private String driver;
            @SerializedName(value="mode")
            private String mode;
            @SerializedName(value="rw")
            private Boolean rw;
            @SerializedName(value="propagation")
            private String propagation;

            public Mount(DockerContainerMount mount) {
                this.name = mount.getName();
                this.source = mount.getSource();
                this.destination = mount.getDestination();
                this.driver = mount.getDriver();
                this.mode = mount.getMode();
                this.rw = mount.getRw();
                this.propagation = mount.getPropagation();
            }
        }

        private static class HostConfig {
            private String networkMode;

            public HostConfig(DockerContainerHostConfig config) {
                this.networkMode = config.getNetworkMode();
            }
        }
    }
}

