/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.container;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class GetContainers
extends Route<List<?>> {
    private Docker docker = Docker.getInstance();

    public GetContainers(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<ContainerResult> execute() throws Exception {
        ArrayList<ContainerResult> results = new ArrayList<ContainerResult>();
        for (DockerContainer dockerContainer : this.docker.getContainers().getAll()) {
            results.add(new ContainerResult(dockerContainer));
        }
        return results;
    }

    private static class ContainerResult {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="imageId")
        private String imageId;

        public ContainerResult(DockerContainer container) {
            this.id = container.getId();
            this.imageId = container.getImageId();
        }
    }
}

