/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.container;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.DockerExposedPort;
import com.gamedash.daemon.docker.DockerHostConfig;
import com.gamedash.daemon.docker.DockerPortBinding;
import com.gamedash.daemon.docker.DockerVolume;
import com.gamedash.daemon.docker.container.IDockerContainerBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class CreateContainer
extends Route<String> {
    private final Docker docker = Docker.getInstance();

    public CreateContainer(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        IDockerContainerBuilder builder = this.docker.getContainers().create(this.request.getInput().getParameters().get("imageName").getValue());
        String name = this.getName();
        if (name != null) {
            builder.withName(name);
        }
        builder.withVolumes(this.getVolumes());
        builder.withHostConfig(this.getHostConfig());
        return builder.build();
    }

    private String getName() throws Exception {
        if (this.request.getInput().getParameters().exists("name")) {
            return this.request.getInput().getParameters().get("name").getValue();
        }
        return null;
    }

    private DockerHostConfig getHostConfig() throws Exception {
        DockerHostConfig hostConfig = new DockerHostConfig();
        hostConfig.withPortBindings(this.getPortBindings());
        return hostConfig;
    }

    private List<DockerVolume> getVolumes() throws RequestParameterException {
        if (!this.request.getInput().getParameters().exists("volumes")) {
            return new ArrayList<DockerVolume>();
        }
        VolumeParameter[] volumesParameterArray = this.request.getInput().getParameters().get("volumes").getJsonArray(VolumeParameter[].class);
        ArrayList<DockerVolume> volumes = new ArrayList<DockerVolume>();
        for (VolumeParameter volumeParameter : volumesParameterArray) {
            volumes.add(new DockerVolume(volumeParameter.origin, volumeParameter.target));
        }
        return volumes;
    }

    private List<DockerPortBinding> getPortBindings() throws RequestParameterException {
        if (!this.request.getInput().getParameters().exists("portBindings")) {
            return new ArrayList<DockerPortBinding>();
        }
        PortBindingParameter[] bindingsParameterArray = this.request.getInput().getParameters().get("portBindings").getJsonArray(PortBindingParameter[].class);
        ArrayList<DockerPortBinding> bindings = new ArrayList<DockerPortBinding>();
        for (PortBindingParameter parameter : bindingsParameterArray) {
            DockerExposedPort exposedPort = DockerExposedPort.create(parameter.exposedPort, parameter.exposedPortProtocol);
            bindings.add(new DockerPortBinding(parameter.port, exposedPort));
        }
        return bindings;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"imageName"};
    }

    static class PortBindingParameter {
        @SerializedName(value="port")
        public Integer port;
        @SerializedName(value="exposedPort")
        public Integer exposedPort;
        @SerializedName(value="exposedPortProtocol")
        public String exposedPortProtocol;

        PortBindingParameter() {
        }
    }

    static class VolumeParameter {
        @SerializedName(value="origin")
        public String origin;
        @SerializedName(value="target")
        public String target;

        VolumeParameter() {
        }
    }
}

