/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.authentication.Authentication;
import com.gamedash.daemon.api.server.response.transformer.JsonResponseTransformer;
import com.gamedash.daemon.api.server.route.routes.GetTime;
import com.gamedash.daemon.api.server.route.routes.GetUptime;
import com.gamedash.daemon.api.server.route.routes.Ping;
import com.gamedash.daemon.api.server.route.routes.Root;
import com.gamedash.daemon.api.server.route.routes.docker.container.CreateContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.GetContainers;
import com.gamedash.daemon.api.server.route.routes.docker.container.GetRunningContainers;
import com.gamedash.daemon.api.server.route.routes.docker.container.KillContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.RemoveContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.StartContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.StopContainer;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Append;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Copy;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetProperties;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetRealPath;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetSize;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetZipSize;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.IsDirectory;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.MD5Checksum;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Read;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.SHA1Checksum;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Unzip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Write;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Create;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Move;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.GetContents;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.Walk;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.Download;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.DownloadAsync;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.GetDownloadSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Exists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.MakeExecutable;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Zip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.Serve;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.UpdateAll;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.CreateSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.DeleteSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.GetSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.SessionExists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.WriteChunk;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.DisconnectSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.GetAllSessions;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.GetAllSessionsForUser;
import com.gamedash.daemon.api.server.route.routes.network.port.Get;
import com.gamedash.daemon.api.server.route.routes.network.port.GetAll;
import com.gamedash.daemon.api.server.route.routes.operatingSystem.linux.GetRelease;
import com.gamedash.daemon.api.server.route.routes.packageManager.InstallPackage;
import com.gamedash.daemon.api.server.route.routes.packageManager.UninstallPackage;
import com.gamedash.daemon.api.server.route.routes.process.GetAllProcess;
import com.gamedash.daemon.api.server.route.routes.process.GetProcess;
import com.gamedash.daemon.api.server.route.routes.process.GetProcessChildren;
import com.gamedash.daemon.api.server.route.routes.process.GetProcessResourceUsage;
import com.gamedash.daemon.api.server.route.routes.process.LimitProcessResources;
import com.gamedash.daemon.api.server.route.routes.process.ProcessExists;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.ChildProcessExists;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.ChildProcessHasExited;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.ChildProcessIsRunning;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.CreateChildProcess;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetAllChildProcesses;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetChildProcess;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetChildProcessDescendants;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetChildProcessExitCode;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.KillChildProcess;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.StopChildProcess;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.GetChildProcessOutput;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.SendChildProcessInput;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.reference.DeleteChildProcessReference;
import com.gamedash.daemon.api.server.route.routes.relay.server.GetAllInstances;
import com.gamedash.daemon.api.server.route.routes.relay.server.channel.BroadcastMessageToChannel;
import com.gamedash.daemon.api.server.route.routes.relay.server.channel.GetAllChannels;
import com.gamedash.daemon.api.server.route.routes.system.GetInfo;
import com.gamedash.daemon.api.server.route.routes.system.GetUsage;
import com.gamedash.daemon.api.server.route.routes.system.Reboot;
import com.gamedash.daemon.api.server.route.routes.system.Shutdown;
import com.gamedash.daemon.api.server.route.routes.system.environment.GetEnvironmentVariables;
import com.gamedash.daemon.api.server.route.routes.system.os.fileSystem.fileStore.GetFileStoreForPath;
import com.gamedash.daemon.api.server.route.routes.system.os.fileSystem.fileStore.GetFileStores;
import com.gamedash.daemon.api.server.route.routes.system.storage.GetPartitionForPath;
import com.gamedash.daemon.api.server.route.routes.system.user.Delete;
import com.gamedash.daemon.api.server.route.routes.system.user.authentication.SetPassword;
import com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file.AssignPermissions;
import com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file.SetHomeDirectory;
import javax.servlet.MultipartConfigElement;
import spark.route.HttpMethod;

public class Routes {
    private final ApiServer apiServer;

    public Routes(ApiServer apiServer) {
        this.apiServer = apiServer;
    }

    public void register() {
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/", Root.class, new JsonResponseTransformer()).before((request, response) -> response.setType("application/json"));
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/uptime", GetUptime.class, new JsonResponseTransformer()).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/time", GetTime.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/ping", Ping.class).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/usage", GetUsage.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/info", GetInfo.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/storage/partition/forpath", GetPartitionForPath.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/os/filesystem/filestore/all", GetFileStores.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/os/filesystem/filestore/forpath", GetFileStoreForPath.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/environment/variable/all", GetEnvironmentVariables.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/uptime", com.gamedash.daemon.api.server.route.routes.system.GetUptime.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/system/shutdown", Shutdown.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/system/reboot", Reboot.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/relay/server/all", GetAllInstances.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/relay/server/:instance_id/channel/all", GetAllChannels.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/relay/server/:instance_id/channel/:channel_name/broadcast", BroadcastMessageToChannel.class, new JsonResponseTransformer()).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/process/childprocess", CreateChildProcess.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/all", GetAllChildProcesses.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/isrunning", ChildProcessIsRunning.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/exitcode", GetChildProcessExitCode.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/hasexited", ChildProcessHasExited.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/exists", ChildProcessExists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/process/childprocess/:id", StopChildProcess.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id", GetChildProcess.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/process/childprocess/:id/kill", KillChildProcess.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/process/childprocess/:id/io/input", SendChildProcessInput.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/io/output", GetChildProcessOutput.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/descendant/all", GetChildProcessDescendants.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/process/childprocess/reference/:name", DeleteChildProcessReference.class, new JsonResponseTransformer()).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/all", GetAllProcess.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id", GetProcess.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/process/:id", GetProcess.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id/exists", ProcessExists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/process/:id/resource/limit", LimitProcessResources.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id/children", GetProcessChildren.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id/resource/usage", GetProcessResourceUsage.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/group/zip", Zip.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/realpath", GetRealPath.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/group/exists", Exists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/group/copy", com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Copy.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file", Write.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/isdirectory", IsDirectory.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/checksum/md5", MD5Checksum.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/checksum/sha1", SHA1Checksum.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/copy", Copy.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file", com.gamedash.daemon.api.server.route.routes.fileSystem.file.Create.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/file", com.gamedash.daemon.api.server.route.routes.fileSystem.file.Delete.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/download", Download.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/download/async", DownloadAsync.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/download/session/:session_id", GetDownloadSession.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/exists", com.gamedash.daemon.api.server.route.routes.fileSystem.file.Exists.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/move", com.gamedash.daemon.api.server.route.routes.fileSystem.file.Move.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file", Read.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/properties", GetProperties.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/size", GetSize.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file/group/executable", MakeExecutable.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/zip/size", GetZipSize.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/unzip", Unzip.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file", Write.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/upload/session", CreateSession.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/file/upload/session/:session_id", DeleteSession.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/upload/session/:session_id/exists", SessionExists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/upload/session/:session_id/chunk/:chunk_id/write", "multipart/form-data", WriteChunk.class, new JsonResponseTransformer()).before((request, response) -> {
            request.getRaw().setAttribute("org.eclipse.jetty.multipartConfig", new MultipartConfigElement(""));
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/upload/session/:session_id", GetSession.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file/append", Append.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/copy", com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Copy.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/directory", Create.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/file/directory", com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Delete.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/directory/move", Move.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/directory/size", com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.GetSize.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/directory/contents", GetContents.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/directory/contents/walk", Walk.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/network/port/all", GetAll.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/network/port/:number", Get.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/system/user/:name", com.gamedash.daemon.api.server.route.routes.system.user.Create.class);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/system/user/:name", Delete.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/user/:name/exists", com.gamedash.daemon.api.server.route.routes.system.user.Exists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/system/user/:name/authentication/password", SetPassword.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/system/user/:name/filesystem/file/home", SetHomeDirectory.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/system/user/:name/filesystem/file/permission/assign", AssignPermissions.class);
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file/hotlink/update/all", UpdateAll.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/hotlink/:id/serve", Serve.class);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/hotlink/:id/serve/*", Serve.class);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/remote/user/:user_name/session/all", GetAllSessionsForUser.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/remote/user/session/all", GetAllSessions.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/remote/user/:user_name/session", DisconnectSession.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/packagemanager/:name/install", InstallPackage.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/packagemanager/:name/uninstall", UninstallPackage.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/operatingSystem/linux/release", GetRelease.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/docker/container/all", GetContainers.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/docker/container/running", GetRunningContainers.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/docker/container", CreateContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/docker/container/:container_id", RemoveContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/docker/container/:container_id/start", StartContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/docker/container/:container_id/stop", StopContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/docker/container/:container_id/kill", KillContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
    }
}

