/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.jline.builtins.ssh.Ssh;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ShellFactoryImpl
implements Factory<Command> {
    private final Consumer<Ssh.ShellParams> shell;

    public ShellFactoryImpl(Consumer<Ssh.ShellParams> shell) {
        this.shell = shell;
    }

    private static void flush(OutputStream ... streams) {
        for (OutputStream s2 : streams) {
            try {
                s2.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Command create() {
        return new ShellImpl();
    }

    public class ShellImpl
    implements Command,
    SessionAware {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;
        private boolean closed;

        @Override
        public void setInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        @Override
        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        @Override
        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(Environment env) throws IOException {
            try {
                new Thread(() -> {
                    try {
                        this.run(env);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new IOException("Unable to start shell", e);
            }
        }

        public void run(Environment env) throws Exception {
            try {
                Terminal terminal = TerminalBuilder.builder().name("JLine SSH").type(env.getEnv().get("TERM")).system(false).streams(this.in, this.out).build();
                terminal.setSize(new Size(Integer.parseInt(env.getEnv().get("COLUMNS")), Integer.parseInt(env.getEnv().get("LINES"))));
                Attributes attr = terminal.getAttributes();
                for (Map.Entry<PtyMode, Integer> e : env.getPtyModes().entrySet()) {
                    switch (e.getKey()) {
                        case VINTR: {
                            attr.setControlChar(Attributes.ControlChar.VINTR, e.getValue());
                            break;
                        }
                        case VQUIT: {
                            attr.setControlChar(Attributes.ControlChar.VQUIT, e.getValue());
                            break;
                        }
                        case VERASE: {
                            attr.setControlChar(Attributes.ControlChar.VERASE, e.getValue());
                            break;
                        }
                        case VKILL: {
                            attr.setControlChar(Attributes.ControlChar.VKILL, e.getValue());
                            break;
                        }
                        case VEOF: {
                            attr.setControlChar(Attributes.ControlChar.VEOF, e.getValue());
                            break;
                        }
                        case VEOL: {
                            attr.setControlChar(Attributes.ControlChar.VEOL, e.getValue());
                            break;
                        }
                        case VEOL2: {
                            attr.setControlChar(Attributes.ControlChar.VEOL2, e.getValue());
                            break;
                        }
                        case VSTART: {
                            attr.setControlChar(Attributes.ControlChar.VSTART, e.getValue());
                            break;
                        }
                        case VSTOP: {
                            attr.setControlChar(Attributes.ControlChar.VSTOP, e.getValue());
                            break;
                        }
                        case VSUSP: {
                            attr.setControlChar(Attributes.ControlChar.VSUSP, e.getValue());
                            break;
                        }
                        case VDSUSP: {
                            attr.setControlChar(Attributes.ControlChar.VDSUSP, e.getValue());
                            break;
                        }
                        case VREPRINT: {
                            attr.setControlChar(Attributes.ControlChar.VREPRINT, e.getValue());
                            break;
                        }
                        case VWERASE: {
                            attr.setControlChar(Attributes.ControlChar.VWERASE, e.getValue());
                            break;
                        }
                        case VLNEXT: {
                            attr.setControlChar(Attributes.ControlChar.VLNEXT, e.getValue());
                            break;
                        }
                        case VSTATUS: {
                            attr.setControlChar(Attributes.ControlChar.VSTATUS, e.getValue());
                            break;
                        }
                        case VDISCARD: {
                            attr.setControlChar(Attributes.ControlChar.VDISCARD, e.getValue());
                            break;
                        }
                        case ECHO: {
                            attr.setLocalFlag(Attributes.LocalFlag.ECHO, e.getValue() != 0);
                            break;
                        }
                        case ICANON: {
                            attr.setLocalFlag(Attributes.LocalFlag.ICANON, e.getValue() != 0);
                            break;
                        }
                        case ISIG: {
                            attr.setLocalFlag(Attributes.LocalFlag.ISIG, e.getValue() != 0);
                            break;
                        }
                        case ICRNL: {
                            attr.setInputFlag(Attributes.InputFlag.ICRNL, e.getValue() != 0);
                            break;
                        }
                        case INLCR: {
                            attr.setInputFlag(Attributes.InputFlag.INLCR, e.getValue() != 0);
                            break;
                        }
                        case IGNCR: {
                            attr.setInputFlag(Attributes.InputFlag.IGNCR, e.getValue() != 0);
                            break;
                        }
                        case OCRNL: {
                            attr.setOutputFlag(Attributes.OutputFlag.OCRNL, e.getValue() != 0);
                            break;
                        }
                        case ONLCR: {
                            attr.setOutputFlag(Attributes.OutputFlag.ONLCR, e.getValue() != 0);
                            break;
                        }
                        case ONLRET: {
                            attr.setOutputFlag(Attributes.OutputFlag.ONLRET, e.getValue() != 0);
                            break;
                        }
                        case OPOST: {
                            attr.setOutputFlag(Attributes.OutputFlag.OPOST, e.getValue() != 0);
                        }
                    }
                }
                terminal.setAttributes(attr);
                env.addSignalListener(signals -> {
                    terminal.setSize(new Size(Integer.parseInt(env.getEnv().get("COLUMNS")), Integer.parseInt(env.getEnv().get("LINES"))));
                    terminal.raise(Terminal.Signal.WINCH);
                }, Signal.WINCH);
                ShellFactoryImpl.this.shell.accept(new Ssh.ShellParams(env.getEnv(), terminal, this::destroy));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.flush(new OutputStream[]{this.out, this.err});
                ShellFactoryImpl.close(this.in, this.out, this.err);
                this.callback.onExit(0);
            }
        }
    }
}

