/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SshdEventListener;
import org.apache.sshd.common.util.ValidateUtils;

public final class EventListenerUtils {
    public static final Comparator<EventListener> LISTENER_INSTANCE_COMPARATOR = (l1, l2) -> {
        String s2;
        int nRes;
        if (l1 == l2) {
            return 0;
        }
        if (l1 == null) {
            return 1;
        }
        if (l2 == null) {
            return -1;
        }
        Class<?> c1 = l1.getClass();
        Class<?> c2 = l2.getClass();
        boolean checkHashCodes = true;
        if (Proxy.isProxyClass(c1)) {
            if (!Proxy.isProxyClass(c2)) return 1;
            checkHashCodes = false;
        } else if (Proxy.isProxyClass(c2)) {
            return -1;
        }
        if (checkHashCodes && (nRes = Integer.compare(l1.hashCode(), l2.hashCode())) != 0) {
            return nRes;
        }
        nRes = Integer.compare(System.identityHashCode(l1), System.identityHashCode(l2));
        if (nRes != 0) {
            return nRes;
        }
        if (c1 != c2) {
            return c1.getName().compareTo(c2.getName());
        }
        String s1 = Objects.toString(l1.toString(), "");
        nRes = s1.compareTo(s2 = Objects.toString(l2.toString(), ""));
        if (nRes == 0) throw new UnsupportedOperationException("Ran out of options to compare instance of " + s1 + " vs. " + s2);
        return nRes;
    };

    private EventListenerUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <L extends SshdEventListener> Set<L> synchronizedListenersSet(Collection<? extends L> listeners) {
        Set<L> s2 = EventListenerUtils.synchronizedListenersSet();
        if (GenericUtils.size(listeners) > 0) {
            s2.addAll(listeners);
        }
        return s2;
    }

    public static <L extends SshdEventListener> Set<L> synchronizedListenersSet() {
        return Collections.synchronizedSet(new TreeSet<EventListener>(LISTENER_INSTANCE_COMPARATOR));
    }

    public static <T extends SshdEventListener> T proxyWrapper(Class<T> listenerType, Iterable<? extends T> listeners) {
        return EventListenerUtils.proxyWrapper(listenerType, listenerType.getClassLoader(), listeners);
    }

    public static <T extends SshdEventListener> T proxyWrapper(Class<T> listenerType, ClassLoader loader, Iterable<? extends T> listeners) {
        Objects.requireNonNull(listenerType, "No listener type specified");
        ValidateUtils.checkTrue(listenerType.isInterface(), "Target proxy is not an interface: %s", (Object)listenerType.getSimpleName());
        Objects.requireNonNull(listeners, "No listeners container provided");
        Object wrapper = Proxy.newProxyInstance(loader, new Class[]{listenerType}, (proxy, method, args) -> {
            Throwable err = null;
            for (SshdEventListener l : listeners) {
                try {
                    method.invoke((Object)l, args);
                }
                catch (Throwable t) {
                    Throwable e = GenericUtils.peelException(t);
                    err = GenericUtils.accumulateException(err, e);
                }
            }
            if (err != null) {
                throw err;
            }
            return null;
        });
        return (T)((SshdEventListener)listenerType.cast(wrapper));
    }
}

