/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.impl.DefaultFtpRequest;
import org.apache.ftpserver.impl.FtpHandler;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.logging.MdcInjectionFilter;

public class FtpHandlerAdapter
extends IoHandlerAdapter {
    private final FtpServerContext context;
    private FtpHandler ftpHandler;

    public FtpHandlerAdapter(FtpServerContext context, FtpHandler ftpHandler) {
        this.context = context;
        this.ftpHandler = ftpHandler;
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        FtpIoSession ftpSession = new FtpIoSession(session, this.context);
        this.ftpHandler.exceptionCaught(ftpSession, cause);
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        FtpIoSession ftpSession = new FtpIoSession(session, this.context);
        DefaultFtpRequest request = new DefaultFtpRequest(message.toString());
        this.ftpHandler.messageReceived(ftpSession, request);
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
        FtpIoSession ftpSession = new FtpIoSession(session, this.context);
        this.ftpHandler.messageSent(ftpSession, (FtpReply)message);
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        FtpIoSession ftpSession = new FtpIoSession(session, this.context);
        this.ftpHandler.sessionClosed(ftpSession);
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        FtpIoSession ftpSession = new FtpIoSession(session, this.context);
        MdcInjectionFilter.setProperty(session, "session", ftpSession.getSessionId().toString());
        this.ftpHandler.sessionCreated(ftpSession);
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        FtpIoSession ftpSession = new FtpIoSession(session, this.context);
        this.ftpHandler.sessionIdle(ftpSession, status);
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        FtpIoSession ftpSession = new FtpIoSession(session, this.context);
        this.ftpHandler.sessionOpened(ftpSession);
    }

    public FtpHandler getFtpHandler() {
        return this.ftpHandler;
    }

    public void setFtpHandler(FtpHandler handler) {
        this.ftpHandler = handler;
    }
}

