/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem.nativefs;

import java.io.File;
import org.apache.ftpserver.filesystem.nativefs.impl.NativeFileSystemView;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileSystemFactory
implements FileSystemFactory {
    private final Logger LOG = LoggerFactory.getLogger(NativeFileSystemFactory.class);
    private boolean createHome;
    private boolean caseInsensitive;

    public boolean isCreateHome() {
        return this.createHome;
    }

    public void setCreateHome(boolean createHome) {
        this.createHome = createHome;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystemView createFileSystemView(User user) throws FtpException {
        User user2 = user;
        synchronized (user2) {
            if (this.createHome) {
                String homeDirStr = user.getHomeDirectory();
                File homeDir = new File(homeDirStr);
                if (homeDir.isFile()) {
                    this.LOG.warn("Not a directory :: " + homeDirStr);
                    throw new FtpException("Not a directory :: " + homeDirStr);
                }
                if (!homeDir.exists() && !homeDir.mkdirs()) {
                    this.LOG.warn("Cannot create user home :: " + homeDirStr);
                    throw new FtpException("Cannot create user home :: " + homeDirStr);
                }
            }
            NativeFileSystemView fsView = new NativeFileSystemView(user, this.caseInsensitive);
            return fsView;
        }
    }
}

