/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedDataTransferFtpReply;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RETR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RETR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            long transSz;
            InputStream is;
            boolean failure;
            FtpFile file;
            String fileName;
            block28: {
                DataConnection dataConnection;
                InetAddress address;
                long skipLen = session.getFileOffset();
                fileName = request.getArgument();
                if (fileName == null) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 501, "RETR", null, null));
                    return;
                }
                file = null;
                try {
                    file = session.getFileSystemView().getFile(fileName);
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", ex);
                }
                if (file == null) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.missing", fileName, file));
                    return;
                }
                fileName = file.getAbsolutePath();
                if (!file.doesExist()) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.missing", fileName, file));
                    return;
                }
                if (!file.isFile()) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.invalid", fileName, file));
                    return;
                }
                if (!file.isReadable()) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.permission", fileName, file));
                    return;
                }
                ServerDataConnectionFactory connFactory = session.getDataConnection();
                if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                    session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                    return;
                }
                session.write(LocalizedFtpReply.translate(session, request, context, 150, "RETR", null));
                failure = false;
                is = null;
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception getting the output data stream", e);
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 425, "RETR", null, file));
                    session.resetState();
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                transSz = 0L;
                try {
                    is = this.openInputStream(session, file, skipLen);
                    transSz = dataConnection.transferToClient(session.getFtpletSession(), is);
                    if (is != null) {
                        is.close();
                    }
                    this.LOG.info("File downloaded {}", (Object)fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                    if (ftpStat == null) break block28;
                    ftpStat.setDownload(session, file, transSz);
                }
                catch (SocketException ex) {
                    this.LOG.debug("Socket exception during data transfer", ex);
                    failure = true;
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 426, "RETR", fileName, file, transSz));
                    IoUtils.close(is);
                }
                catch (IOException ex2) {
                    this.LOG.debug("IOException during data transfer", ex2);
                    failure = true;
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 551, "RETR", fileName, file, transSz));
                    {
                        catch (Throwable throwable) {
                            IoUtils.close(is);
                            throw throwable;
                        }
                    }
                    IoUtils.close(is);
                }
            }
            IoUtils.close(is);
            if (!failure) {
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 226, "RETR", fileName, file, transSz));
            }
        }
        finally {
            session.resetState();
            session.getDataConnection().closeDataConnection();
        }
    }

    public InputStream openInputStream(FtpIoSession session, FtpFile file, long skipLen) throws IOException {
        InputStream in;
        if (session.getDataType() == DataType.ASCII) {
            long offset = 0L;
            in = new BufferedInputStream(file.createInputStream(0L));
            while (offset++ < skipLen) {
                int c = in.read();
                if (c == -1) {
                    throw new IOException("Cannot skip");
                }
                if (c != 10) continue;
                ++offset;
            }
        } else {
            in = file.createInputStream(skipLen);
        }
        return in;
    }
}

