/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.hardware.processor.governor;

import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.governor.ProcessorGovernor;
import com.gamedash.daemon.system.hardware.processor.governor.implementation.IGovernorsImplementation;
import com.gamedash.daemon.system.hardware.processor.governor.implementation.linux.LinuxGovernorsImplementation;
import com.gamedash.daemon.system.hardware.processor.governor.implementation.windows.WindowsGovernorsImplementation;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class ProcessorGovernors {
    private static IGovernorsImplementation implementation;

    public static boolean isAvailable() {
        return ProcessorGovernors.getImplementation().isAvailable();
    }

    public static List<ProcessorGovernor> getAvailable(Processor processor) throws Exception {
        return ProcessorGovernors.getImplementation().getAvailable(processor);
    }

    public static ProcessorGovernor get(String name) {
        return ProcessorGovernors.getImplementation().get(name);
    }

    public static ProcessorGovernor getForProcessor(Processor processor) throws Exception {
        return ProcessorGovernors.getImplementation().getForProcessor(processor);
    }

    public static ProcessorGovernor getPerformanceGovernor() throws Exception {
        return ProcessorGovernors.getImplementation().getPerformanceGovernor();
    }

    public static IGovernorsImplementation getImplementation() {
        if (implementation == null) {
            IGovernorsImplementation implementation;
            if (SystemUtils.IS_OS_LINUX) {
                implementation = new LinuxGovernorsImplementation();
            } else if (SystemUtils.IS_OS_WINDOWS) {
                implementation = new WindowsGovernorsImplementation();
            } else {
                throw new RuntimeException("Unsupported");
            }
            ProcessorGovernors.implementation = implementation;
        }
        return implementation;
    }
}

