/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.store.keyValue;

import com.gamedash.daemon.store.keyValue.IKeyValue;
import com.gamedash.daemon.store.keyValue.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MemoryKeyValueStore
implements IKeyValue {
    private List<Value> values = new CopyOnWriteArrayList<Value>();

    @Override
    public List<Value> getValues() {
        return this.values;
    }

    @Override
    public Object getValue(String name) {
        for (Value storeValue : this.getValues()) {
            if (!storeValue.getName().equals(name)) continue;
            return storeValue.getValue();
        }
        return null;
    }

    @Override
    public boolean valueExists(String name) {
        for (Value value : this.getValues()) {
            if (!value.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setValue(String name, Object value) {
        this.deleteValue(name);
        this.values.add(new Value(name, value));
    }

    @Override
    public void deleteValue(String name) {
        for (Value value : this.getValues()) {
            if (!value.getName().equals(name)) continue;
            this.values.remove(value);
        }
    }

    @Override
    public void clear() {
        this.values = new ArrayList<Value>();
    }
}

