/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.singleton;

import java.util.ArrayList;
import java.util.List;

public abstract class SingletonList<T> {
    private List<T> list;

    public List<T> getAll() {
        return this.list;
    }

    public T find(IFindCallback<T> callback) {
        if (this.getAll() != null) {
            for (T item : this.getAll()) {
                if (!callback.compare(item)) continue;
                return item;
            }
        }
        return null;
    }

    public void add(T item) {
        this.acquireList().add(item);
    }

    public void addAll(List<T> items) {
        this.acquireList().addAll(items);
    }

    public void remove(T item) {
        if (this.getAll() != null) {
            this.getAll().forEach(_item -> {
                if (this.compare(item, _item)) {
                    this.list.remove(_item);
                }
            });
        }
    }

    public boolean notEmpty() {
        return this.list != null;
    }

    public void clear() {
        this.list = null;
    }

    public abstract boolean compare(Object var1, Object var2);

    private List<T> acquireList() {
        if (this.list == null) {
            this.list = new ArrayList<T>();
        }
        return this.list;
    }

    @FunctionalInterface
    public static interface IFindCallback<T> {
        public boolean compare(T var1);
    }
}

