/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.windows;

import com.gamedash.daemon.exception.NotImplementedException;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcess;
import com.gamedash.daemon.platform.windows.process.childProcess.io.WindowsPlatformChildProcessOutputItem;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Io
extends OutputHandler
implements IIo {
    private static Logger logger = LoggerFactory.getLogger(Io.class);
    private boolean isListening = false;

    Io(ChildProcess childProcess) throws IOException {
        super(childProcess);
    }

    @Override
    public void write(String value) throws Exception {
        this.childProcess.getApi(WindowsPlatformChildProcess.class).sendInput(value);
    }

    @Override
    public void waitFor() throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void listen() {
        if (this.isListening) {
            throw new ProcessException("Already listening to io");
        }
        this.isListening = true;
        new Thread(() -> {
            try {
                this.childProcess.getApi(WindowsPlatformChildProcess.class).getIo().onOutput((WindowsPlatformChildProcessOutputItem windowsOutputItem) -> {
                    OutputItem outputItem = new OutputItem(windowsOutputItem.getValue(), windowsOutputItem.isError());
                    this.addOutputItem(outputItem);
                    this.invokeOnOutputListener(outputItem);
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }

    @Override
    public void destroy() {
    }
}

