/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.pty;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.AbstractTerminal;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.pty.Io;
import com.pty4j.PtyProcess;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pty
extends AbstractTerminal
implements ITerminal {
    public static final Logger logger = LoggerFactory.getLogger(Pty.class);
    private ChildProcess childProcess;
    private PtyProcess api;
    private IIo io;

    public Pty(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new Io(this.childProcess);
    }

    @Override
    public void spawn(String[] args) throws Exception {
        Map<String, String> environmentVariables = this.childProcess.getEnvironmentVariables();
        this.api = PtyProcess.exec(args, environmentVariables, this.childProcess.hasWorkingDirectory() != false ? this.childProcess.getWorkingDirectory().toString() : null);
        this.listenForExit();
        this.getIo().listen();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        IProcess[] children = (IProcess[])this.childProcess.getChildren().toArray(IProcess[]::new);
        if (this.api.supportsNormalTermination()) {
            this.api.destroy();
        } else {
            this.api.destroyForcibly();
        }
        if (children.length > 0) {
            Processes.stop(children);
        }
        this.waitForExit(5);
        this.api.destroyForcibly();
        if (children.length > 0) {
            Processes.kill(children);
        }
        this.waitForExit();
    }

    @Override
    public int getExitCode() {
        return this.api.exitValue();
    }

    @Override
    public boolean isRunning() {
        return this.api.isRunning();
    }

    @Override
    public int getId() {
        return this.api.getPid();
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.api);
    }

    private void listenForExit() {
        Thread thread = new Thread(() -> {
            try {
                if (this.isRunning()) {
                    this.api.waitFor();
                }
                this.io.waitFor();
                this.handleExit();
            }
            catch (Exception e) {
                logger.debug(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.start();
    }
}

