/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal;

import com.gamedash.daemon.process.childProcess.terminal.ExitListener;
import com.gamedash.daemon.process.childProcess.terminal.IOnExitCallback;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTerminal
implements ITerminal {
    protected ExitListener exitListener = new ExitListener();
    private boolean exited = false;

    @Override
    public void waitForExit() throws Exception {
        this.waitForExit(null);
    }

    public void waitForExit(Integer seconds) throws Exception {
        CountDownLatch exitLatch = new CountDownLatch(1);
        this.onExit(() -> exitLatch.countDown());
        if (seconds != null) {
            exitLatch.await(seconds.intValue(), TimeUnit.SECONDS);
        } else {
            exitLatch.await();
        }
    }

    @Override
    public void onExit(IOnExitCallback callback) {
        if (this.hasExited()) {
            callback.invoke();
        }
        this.exitListener.addCallback(callback);
    }

    @Override
    public boolean hasExited() {
        return this.exited;
    }

    public void setHasExited(boolean exited) {
        this.exited = exited;
    }

    protected Thread handleExit() {
        this.setHasExited(true);
        return this.exitListener.invokeAsync();
    }
}

