/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.io.listener;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.io.listener.AbstractListener;
import com.gamedash.daemon.relay.Message;
import com.gamedash.daemon.relay.client.channel.Channel;
import com.google.common.util.concurrent.RateLimiter;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RelayListener
extends AbstractListener {
    private List<Channel> channels;
    private RateLimiter rateLimit = RateLimiter.create(3000.0, 0L, TimeUnit.MINUTES);

    public RelayListener(ChildProcess childProcess, List<Channel> channels) {
        this.channels = channels;
    }

    @Override
    public void onOutput(OutputItem item) throws Exception {
        if (!this.rateLimit.tryAcquire()) {
            return;
        }
        com.gamedash.daemon.relay.OutputItem outputItem = new com.gamedash.daemon.relay.OutputItem(item);
        outputItem.setSourceName("process");
        for (Channel channel : this.channels) {
            channel.broadcast(new Message<com.gamedash.daemon.relay.OutputItem>("childprocess.io.output", outputItem));
        }
    }

    public double getRate() {
        return this.rateLimit.getRate();
    }

    public void setRate(double rate) {
        this.rateLimit.setRate(rate);
    }
}

