/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.system.hardware.processor;

import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorConservativeGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorOnDemandGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorPerformanceGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorPowersaveGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorUserspaceGovernor;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.governor.ProcessorGovernor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LinuxProcessorGovernors {
    private static List<ProcessorGovernor> governors = new ArrayList<ProcessorGovernor>(){
        {
            this.add(new ProcessorGovernor(LinuxProcessorConservativeGovernor.class));
            this.add(new ProcessorGovernor(LinuxProcessorOnDemandGovernor.class));
            this.add(new ProcessorGovernor(LinuxProcessorUserspaceGovernor.class));
            this.add(new ProcessorGovernor(LinuxProcessorPowersaveGovernor.class));
            this.add(new ProcessorGovernor(LinuxProcessorPerformanceGovernor.class));
        }
    };

    public static boolean isAvailable() {
        return Files.exists(Paths.get("/sys/devices/system/cpu/cpu/cpu0/cpufreq", new String[0]), new LinkOption[0]);
    }

    public static List<ProcessorGovernor> getAvailable(Processor processor) throws IOException {
        String contents = Files.readString(Paths.get("/sys/devices/system/cpu/cpu" + processor.getId() + "/cpufreq/scaling_available_governors", new String[0]), StandardCharsets.UTF_8);
        return Arrays.stream(contents.split("\\\\s+")).map(LinuxProcessorGovernors::get).collect(Collectors.toList());
    }

    public static ProcessorGovernor get(String name) {
        for (ProcessorGovernor governor : governors) {
            if (!governor.getName().equals(name)) continue;
            return governor;
        }
        return null;
    }

    public static ProcessorGovernor getForProcessor(Processor processor) throws IOException {
        String name = Files.readString(Paths.get("/sys/devices/system/cpu/cpu" + processor.getId() + "/cpufreq/scaling_governor", new String[0]));
        return LinuxProcessorGovernors.get(name);
    }

    public static ProcessorGovernor getPerformanceGovernor() throws Exception {
        return LinuxProcessorGovernors.get("performance");
    }
}

