/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.network.port;

import com.gamedash.daemon.network.port.ProtocolsEnum;
import com.gamedash.daemon.platform.linux.network.port.LinuxNetworkPort;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import java.util.ArrayList;
import java.util.List;

public class LinuxNetworkPorts {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LinuxNetworkPort> getOpen() throws Exception {
        ArrayList<LinuxNetworkPort> ports = new ArrayList<LinuxNetworkPort>();
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("netstat", new String[]{"-tunlp"});
        process.waitForExit();
        int index = 0;
        for (OutputItem item : process.getIo().getOutputItems()) {
            try {
                String[] columns;
                if (index == 0 || item.isError() || item.getValue().equals("") || (columns = item.getValue().split("\\s+"))[3].split(":").length < 2) continue;
                LinuxNetworkPort port = new LinuxNetworkPort(Integer.parseInt(columns[3].split(":")[columns[3].split(":").length - 1]));
                String protocolName = columns[0];
                port.dataLayer.setValue("processId", Integer.parseInt(columns[protocolName.equals("udp") || protocolName.equals("udp6") ? 5 : 6].split("/")[0]));
                port.dataLayer.setValue("protocol", (Object)ProtocolsEnum.getByName(protocolName));
                ports.add(port);
            }
            finally {
                ++index;
            }
        }
        return ports;
    }

    public static LinuxNetworkPort get(int number) throws Exception {
        for (LinuxNetworkPort port : LinuxNetworkPorts.getOpen()) {
            if (port.getNumber() != number) continue;
            return port;
        }
        return new LinuxNetworkPort(number);
    }
}

