/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.cgroup.resource;

import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.platform.linux.cgroup.controller.CPUController;
import com.gamedash.daemon.platform.linux.cgroup.resource.AbstractResource;
import com.gamedash.daemon.platform.linux.cgroup.resource.IResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import oshi.SystemInfo;

public class CPUResource
extends AbstractResource
implements IResource {
    private LinuxCGroup cGroup;
    private Integer percentage = null;

    public CPUResource(LinuxCGroup cGroup) {
        super(cGroup, new CPUController());
        this.cGroup = cGroup;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int percentage) throws Exception {
        this.percentage = percentage;
    }

    @Override
    public void limitProcess(IProcess process) throws Exception {
        super.limitProcess(process);
        this.pushShares();
        if (!this.cGroup.getProcess(process.getId()).resourceIsLimited(this)) {
            this.cGroup.getProcess(process.getId()).addLimitedResource(this);
        }
    }

    private void pushShares() throws Exception {
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgset -r cpu.shares=" + this.getShares() + " " + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not set CPU shares");
        }
    }

    private int getShares() {
        return (int)Math.floor(1024.0f * ((float)this.getPercentage().intValue() / 100.0f));
    }

    public int getMaxShares() {
        SystemInfo systemInfo = new SystemInfo();
        return systemInfo.getHardware().getProcessor().getLogicalProcessors().length * 1024;
    }
}

