/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.fileDownloader;

import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloader;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderFileNotFoundException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessionException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessionResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;

public class FileDownloaderSession {
    private UUID id;
    private URL url;
    private double progressPercentage;
    private boolean hasCompleted = false;
    private boolean hasFailed = false;
    private boolean hasStarted = false;
    private boolean hasEnded = false;
    private FileDownloader fileDownloader;
    private FileDownloaderSessionResult result;

    public FileDownloaderSession(UUID id, File destination, URL url) {
        this.id = id;
        this.url = url;
        this.fileDownloader = new FileDownloader(destination, url);
    }

    public UUID getId() {
        return this.id;
    }

    public URL getUrl() {
        return this.url;
    }

    public void start() throws FileDownloaderSessionException, IOException {
        if (this.hasStarted) {
            throw new FileDownloaderSessionException("Already started download");
        }
        this.hasStarted = true;
        try {
            this.fileDownloader.onProgress(this::setProgressPercentage);
            this.fileDownloader.download();
            this.setResult(new FileDownloaderSessionResult(true));
        }
        catch (Exception e) {
            FileDownloaderSessionResult result = new FileDownloaderSessionResult(false, e.getMessage());
            if (e instanceof FileDownloaderFileNotFoundException) {
                result.setCode("FILE_NOT_FOUND");
            }
            this.setResult(result);
        }
        finally {
            this.setHasEnded(true);
        }
    }

    public double getProgressPercentage() {
        return this.progressPercentage;
    }

    void setProgressPercentage(double percentage) {
        this.progressPercentage = percentage;
    }

    public FileDownloaderSessionResult getResult() {
        return this.result;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    void setResult(FileDownloaderSessionResult result) {
        this.result = result;
    }

    public boolean hasEnded() {
        return this.hasEnded;
    }

    public void setHasEnded(boolean hasEnded) {
        this.hasEnded = hasEnded;
    }
}

