/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container;

import com.gamedash.daemon.docker.implementation.IDockerImplementation;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainer;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerBuilder;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainers;
import com.gamedash.daemon.docker.implementation.generic.GenericDockerImplementation;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainer;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainerBuilder;
import com.github.dockerjava.api.model.Container;
import java.util.ArrayList;
import java.util.List;

public class GenericDockerContainers
implements IDockerImplementationContainers {
    private IDockerImplementation implementation;

    public GenericDockerContainers(IDockerImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    public List<IDockerImplementationContainer> getAll() {
        ArrayList<IDockerImplementationContainer> containers = new ArrayList<IDockerImplementationContainer>();
        for (Container containerModel : (List)GenericDockerImplementation.getClient().listContainersCmd().withShowAll(true).exec()) {
            containers.add(new GenericDockerContainer(this.implementation, containerModel));
        }
        return containers;
    }

    @Override
    public List<IDockerImplementationContainer> getRunning() {
        ArrayList<IDockerImplementationContainer> containers = new ArrayList<IDockerImplementationContainer>();
        for (Container containerModel : (List)GenericDockerImplementation.getClient().listContainersCmd().withShowAll(false).exec()) {
            containers.add(new GenericDockerContainer(this.implementation, containerModel));
        }
        return containers;
    }

    public IDockerImplementationContainer get(String id) throws Exception {
        for (IDockerImplementationContainer container : this.getAll()) {
            if (!container.getId().equals(id)) continue;
            return container;
        }
        return null;
    }

    @Override
    public IDockerImplementationContainerBuilder create(String imageName) {
        return new GenericDockerContainerBuilder(imageName);
    }
}

