/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.container;

import com.gamedash.daemon.docker.DockerExposedPort;
import com.gamedash.daemon.docker.DockerHostConfig;
import com.gamedash.daemon.docker.DockerVolume;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDockerContainerBuilder
implements IDockerImplementationContainerBuilder {
    private String imageName;
    private String name;
    private String hostName;
    private String workingDirectory;
    private String command;
    private Map<String, String> env = new HashMap<String, String>();
    private DockerHostConfig hostConfig;
    private List<DockerExposedPort> exposedPorts = new ArrayList<DockerExposedPort>();
    private List<DockerVolume> volumes = new ArrayList<DockerVolume>();

    public AbstractDockerContainerBuilder(String imageName) {
        this.imageName = imageName;
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void withName(String name) {
        this.name = name;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void withHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public void withWorkingDirectory(String directory) {
        this.workingDirectory = directory;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void withCommand(String command) {
        this.command = command;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    public List<String> getEnvAsList() {
        ArrayList<String> list = new ArrayList<String>();
        this.getEnv().forEach((name, value) -> list.add(name + "=" + value));
        return list;
    }

    @Override
    public void withEnv(Map<String, String> env) {
        this.env = env;
    }

    @Override
    public DockerHostConfig getHostConfig() {
        return this.hostConfig;
    }

    @Override
    public void withHostConfig(DockerHostConfig hostConfig) {
        this.hostConfig = hostConfig;
    }

    @Override
    public List<DockerExposedPort> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public void withExposedPorts(List<DockerExposedPort> exposedPorts) {
        this.exposedPorts = exposedPorts;
    }

    @Override
    public List<DockerVolume> getVolumes() {
        return this.volumes;
    }

    @Override
    public void withVolumes(List<DockerVolume> volumes) {
        this.volumes = volumes;
    }
}

