/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency.install;

import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.Dependency;
import com.gamedash.daemon.dependency.DependencyElevatedPermissionException;
import com.gamedash.daemon.dependency.install.IInstallerManagerProgressCallback;
import com.gamedash.daemon.dependency.install.InstallerManagerProgressListener;
import com.gamedash.daemon.permission.Permissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallManager {
    private static Logger logger = LoggerFactory.getLogger(Dependency.class);
    private Dependency dependency;
    private InstallerManagerProgressListener installProgressListener = new InstallerManagerProgressListener();
    private InstallerManagerProgressListener uninstallProgressListener = new InstallerManagerProgressListener();

    public InstallManager(Dependency dependency) {
        this.dependency = dependency;
    }

    public void install() throws Exception {
        if (this.dependency.isInstalled()) {
            throw new Exception("Dependency " + this.dependency.getName() + " is already installed");
        }
        if (this.dependency.requiresElevatedPermissions() && !Permissions.isRunningWithElevatedPermissions()) {
            throw new DependencyElevatedPermissionException("Installation of dependency " + this.dependency.getName() + " requires the daemon to be running with elevated permissions");
        }
        this.dependency.getInstance().install(progress -> this.installProgressListener.invoke(progress));
        Dependencies.addInstalled(this.dependency);
    }

    public void uninstall() throws Exception {
        if (!this.dependency.isInstalled()) {
            throw new Exception("Dependency " + this.dependency.getName() + " is not installed");
        }
        this.dependency.getInstance().uninstall(progress -> this.uninstallProgressListener.invoke(progress));
        Dependencies.removeInstalled(this.dependency);
    }

    public void onInstallProgress(IInstallerManagerProgressCallback callback) {
        this.installProgressListener.addCallback(callback::invoke);
    }

    public void onUninstallProgress(IInstallerManagerProgressCallback callback) {
        this.uninstallProgressListener.addCallback(callback::invoke);
    }
}

