/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.config;

import com.gamedash.daemon.common.config.ConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class ConfigFile {
    private File file;
    private Properties properties;

    public ConfigFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String getValue(String name) throws ConfigException, IOException {
        return this.getValue(name, String.class);
    }

    public <T> T getValue(String name, Class<T> type) throws ConfigException, IOException {
        if (!this.valueExists(name)) {
            throw new ConfigException("Config value '" + name + "' does not exist");
        }
        String stringValue = this.read().getProperty(name);
        if (type.equals(Boolean.class)) {
            return type.cast(stringValue.equals("true"));
        }
        if (type.equals(Integer.class)) {
            return type.cast(Integer.valueOf(stringValue));
        }
        if (type.equals(String.class)) {
            return type.cast(stringValue);
        }
        throw new ConfigException("Could not convert value of " + name + " to " + type.getName());
    }

    public List<String> getValueAsList(String name) throws IOException {
        String stringValue = this.getValue(name);
        if (stringValue.equals("")) {
            return new ArrayList<String>();
        }
        return Arrays.asList(stringValue.split(","));
    }

    public boolean valueExists(String name) throws IOException {
        return this.read().getProperty(name) != null;
    }

    public <T> void setValue(String name, T value) throws IOException {
        String stringValue;
        if (value instanceof String) {
            stringValue = (String)value;
        } else if (value instanceof Integer) {
            stringValue = Integer.toString((Integer)value);
        } else if (value instanceof List) {
            stringValue = String.join((CharSequence)",", (List)value);
        } else if (value instanceof Boolean) {
            stringValue = (Boolean)value != false ? "true" : "false";
        } else {
            throw new IllegalArgumentException("Invalid value type " + value.getClass().getName());
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            Properties properties = this.read();
            properties.setProperty(name, stringValue);
            properties.store(fileOutputStream, null);
        }
    }

    public void reload() {
        this.properties = null;
    }

    private Properties read() throws IOException {
        if (this.properties == null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.file);){
                this.properties = new Properties();
                this.properties.load(fileInputStream);
            }
        }
        return this.properties;
    }

    public void delete() {
        this.file.delete();
    }

    public File toFile() {
        return this.file;
    }
}

