/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.google.gson.annotations.SerializedName;
import oshi.SystemInfo;

public class GetUsage
extends Route {
    private SystemInfo systemInfo = new SystemInfo();

    public GetUsage(Request request, Response response) {
        super(request, response);
    }

    private double getCpuLoadPercentage() throws Exception {
        long[] ticks = this.systemInfo.getHardware().getProcessor().getSystemCpuLoadTicks();
        Thread.sleep(1000L);
        return Math.floor(this.systemInfo.getHardware().getProcessor().getSystemCpuLoadBetweenTicks(ticks) * 100.0);
    }

    public Details execute() throws Exception {
        Details details = new Details();
        details.cpu.percentage = this.getCpuLoadPercentage();
        details.cpu.frequency = this.systemInfo.getHardware().getProcessor().getMaxFreq();
        details.cpu.count = this.systemInfo.getHardware().getProcessor().getLogicalProcessorCount();
        details.ram.total = this.systemInfo.getHardware().getMemory().getTotal();
        details.ram.free = this.systemInfo.getHardware().getMemory().getAvailable();
        return details;
    }

    static class Ram {
        @SerializedName(value="total")
        public long total;
        @SerializedName(value="free")
        public long free;

        Ram() {
        }
    }

    static class Cpu {
        @SerializedName(value="percentage")
        public double percentage;
        @SerializedName(value="frequency")
        public long frequency;
        @SerializedName(value="count")
        public int count;

        Cpu() {
        }
    }

    static class Details {
        @SerializedName(value="cpu")
        public Cpu cpu = new Cpu();
        @SerializedName(value="ram")
        public Ram ram = new Ram();

        Details() {
        }
    }
}

