/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class GetAll
extends Route<List<?>> {
    public GetAll(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<ResponseChildProcess> execute() throws Exception {
        ArrayList<ResponseChildProcess> processes = new ArrayList<ResponseChildProcess>();
        for (ChildProcess process : ChildProcesses.getAll()) {
            processes.add(new ResponseChildProcess(process));
        }
        return processes;
    }

    private static class ResponseChildProcess {
        @SerializedName(value="id")
        private int id;
        @SerializedName(value="isRunning")
        private boolean isRunning;
        @SerializedName(value="hasExited")
        private boolean hasExited;
        @SerializedName(value="isTerminating")
        private boolean isTerminating;
        @SerializedName(value="canInterrupt")
        private boolean canInterrupt;
        @SerializedName(value="isSelfManaged")
        private boolean isSelfManaged;
        @SerializedName(value="references")
        private List<String> references = new ArrayList<String>();
        @SerializedName(value="timestampCreated")
        private long timestampCreated;
        @SerializedName(value="process")
        private ResponseProcess process;

        public ResponseChildProcess(ChildProcess childProcess) throws Exception {
            this.id = childProcess.getId();
            this.isRunning = childProcess.isRunning();
            this.hasExited = childProcess.hasExited();
            this.isTerminating = childProcess.isTerminating();
            this.isSelfManaged = childProcess.isSelfManaged();
            this.canInterrupt = childProcess.canInterrupt();
            this.timestampCreated = childProcess.getTimeCreated().getTimestamp();
            if (childProcess.isRunning()) {
                this.process = new ResponseProcess(childProcess.getProcess());
            }
        }

        private static class ResponseProcess {
            @SerializedName(value="name")
            private String name;
            @SerializedName(value="commandLine")
            private String[] commandLine;
            @SerializedName(value="workingDirectory")
            private String workingDirectory;

            public ResponseProcess(IProcess process) throws Exception {
                this.name = process.getName();
                this.commandLine = process.getCommandLine();
                this.workingDirectory = process.getWorkingDirectory().toString();
            }
        }
    }
}

