/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessResourceUsageResult;
import com.gamedash.daemon.process.Processes;
import com.google.gson.annotations.SerializedName;

public class GetResourceUsage
extends Route<Object> {
    public GetResourceUsage(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Result execute() throws Exception {
        int id = this.request.getInput().getParameters().get("id").getValue(Integer.class);
        if (!Processes.exists(id)) {
            throw new Exception("Process does not exist");
        }
        IProcess process = Processes.get(id);
        return new Result(process.getResourceUsage());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }

    private static class Result {
        @SerializedName(value="cpu")
        private GetUsageResponseCpu cpu = new GetUsageResponseCpu();
        @SerializedName(value="ram")
        private GetUsageResponseRam ram = new GetUsageResponseRam();

        public Result(ProcessResourceUsageResult result) {
            this.cpu.percentage = result.cpu;
            this.ram.mb = result.ram;
        }

        private static class GetUsageResponseRam {
            @SerializedName(value="mb")
            public long mb = 0L;

            private GetUsageResponseRam() {
            }
        }

        private static class GetUsageResponseCpu {
            @SerializedName(value="percentage")
            public double percentage = 0.0;

            private GetUsageResponseCpu() {
            }
        }
    }
}

