/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlink;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlinks;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletOutputStream;

public class Serve
extends Route<Response> {
    private String id;
    private Hotlink hotlink;

    public Serve(Request request, Response response) throws Exception {
        super(request, response);
        this.id = this.request.getInput().getParameters().get("id").getValue();
    }

    @Override
    public Response execute() throws Exception {
        if (!Hotlinks.exists(this.id)) {
            throw new Exception("Hotlink does not exist");
        }
        this.hotlink = Hotlinks.get(this.id);
        if (!this.hotlink.getFile().exists()) {
            throw new FileNotFoundException("File does not eixst");
        }
        File file = this.getFile();
        if (!file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (!file.isFile()) {
            throw new IOException("Not a file");
        }
        try (ServletOutputStream outputStream = this.response.getSparkResponse().raw().getOutputStream();
             FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.transferTo(outputStream);
            outputStream.flush();
        }
        return this.response;
    }

    private File getFile() throws Exception {
        if (this.hotlink.isDirectory()) {
            if (this.request.getSparkRequest().splat().length < 1) {
                throw new Exception("No path is set");
            }
            String path = this.request.getSparkRequest().splat()[0].replace("..", "");
            return new File(this.hotlink.getFile().getPath(), path);
        }
        return this.hotlink.getFile();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }
}

