/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.download;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.GetDownloadSession;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSession;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessions;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadAsync
extends Route<String> {
    private static Logger logger = LoggerFactory.getLogger(GetDownloadSession.class);

    public DownloadAsync(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File destination = this.getDestination();
        if (destination.exists() && !destination.isFile()) {
            throw new FileNotFoundException("Destination already exists, but is not a file");
        }
        FileDownloaderSession session = FileDownloaderSessions.create(this.getDestination(), this.getUrl());
        new Thread(() -> {
            try {
                session.start();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
        return session.getId().toString();
    }

    private File getDestination() throws RequestParameterException {
        return FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
    }

    private URL getUrl() throws RequestParameterException, MalformedURLException {
        return new URL(new String(Base64.getDecoder().decode(this.request.getInput().getParameters().get("url").getValue())));
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"destination", "url"};
    }
}

