/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents;

import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;

public class ResultFile {
    @SerializedName(value="path")
    private String path;
    @SerializedName(value="isDirectory")
    private Boolean isDirectory;
    @SerializedName(value="size")
    private long size;
    @SerializedName(value="timestamp")
    private TimestampResult timestamp;

    public ResultFile(File directory, File file) throws Exception {
        BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        this.path = directory.toPath().relativize(file.toPath()).toString();
        this.isDirectory = file.isDirectory();
        if (file.isFile()) {
            this.size = file.length();
            this.timestamp = new TimestampResult(attributes.creationTime().toMillis() / 1000L, attributes.lastModifiedTime().toMillis() / 1000L);
        }
    }

    private class TimestampResult {
        @SerializedName(value="created")
        private long created;
        @SerializedName(value="lastModified")
        private long lastModified;

        TimestampResult(long created, long lastModified) {
            this.created = created;
            this.lastModified = lastModified;
        }
    }
}

