/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.codec.digest.DigestUtils;

public class MD5Checksum
extends Route<String> {
    public MD5Checksum(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File file = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string = DigestUtils.md5Hex(is);
            return string;
        }
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

