/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.authentication.Authentication;
import com.gamedash.daemon.api.server.response.transformer.JsonResponseTransformer;
import com.gamedash.daemon.api.server.route.routes.GetTime;
import com.gamedash.daemon.api.server.route.routes.GetUptime;
import com.gamedash.daemon.api.server.route.routes.Ping;
import com.gamedash.daemon.api.server.route.routes.Root;
import com.gamedash.daemon.api.server.route.routes.docker.container.CreateContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.GetContainers;
import com.gamedash.daemon.api.server.route.routes.docker.container.GetRunningContainers;
import com.gamedash.daemon.api.server.route.routes.docker.container.KillContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.RemoveContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.StartContainer;
import com.gamedash.daemon.api.server.route.routes.docker.container.StopContainer;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Append;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Copy;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Delete;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Exists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetProperties;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetRealPath;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetSize;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetZipSize;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.IsDirectory;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.MD5Checksum;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Read;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.SHA1Checksum;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Unzip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Write;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Move;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.GetContents;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.Walk;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.Download;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.DownloadAsync;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.GetDownloadSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.MakeExecutable;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Zip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.Serve;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.UpdateAll;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.CreateSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.DeleteSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.GetSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.SessionExists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.WriteChunk;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.DisconnectSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.GetAllSessions;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.GetAllSessionsForUser;
import com.gamedash.daemon.api.server.route.routes.operatingSystem.linux.GetRelease;
import com.gamedash.daemon.api.server.route.routes.packageManager.InstallPackage;
import com.gamedash.daemon.api.server.route.routes.packageManager.UninstallPackage;
import com.gamedash.daemon.api.server.route.routes.process.Get;
import com.gamedash.daemon.api.server.route.routes.process.GetChildren;
import com.gamedash.daemon.api.server.route.routes.process.GetResourceUsage;
import com.gamedash.daemon.api.server.route.routes.process.LimitResources;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.Create;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetAll;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetExitCode;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.HasExited;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.IsRunning;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.Kill;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.Stop;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.GetOutput;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.SendInput;
import com.gamedash.daemon.api.server.route.routes.system.GetInfo;
import com.gamedash.daemon.api.server.route.routes.system.GetUsage;
import com.gamedash.daemon.api.server.route.routes.system.Reboot;
import com.gamedash.daemon.api.server.route.routes.system.Shutdown;
import com.gamedash.daemon.api.server.route.routes.system.environment.GetEnvironmentVariables;
import com.gamedash.daemon.api.server.route.routes.system.user.authentication.SetPassword;
import com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file.AssignPermissions;
import com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file.SetHomeDirectory;
import javax.servlet.MultipartConfigElement;
import spark.route.HttpMethod;

public class Routes {
    private ApiServer apiServer;

    public Routes(ApiServer apiServer) {
        this.apiServer = apiServer;
    }

    public void register() {
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/", Root.class, new JsonResponseTransformer()).before((request, response) -> response.setType("application/json"));
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/uptime", GetUptime.class, new JsonResponseTransformer()).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/time", GetTime.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/ping", Ping.class).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/usage", GetUsage.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/info", GetInfo.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/environment/variable/all", GetEnvironmentVariables.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/uptime", com.gamedash.daemon.api.server.route.routes.system.GetUptime.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/system/shutdown", Shutdown.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/system/reboot", Reboot.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/process/childprocess", Create.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/all", GetAll.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/isrunning", IsRunning.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/exitcode", GetExitCode.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/hasexited", HasExited.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/exists", com.gamedash.daemon.api.server.route.routes.process.childprocess.Exists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/process/childprocess/:id", Stop.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/process/childprocess/:id/kill", Kill.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/process/childprocess/:id/io/input", SendInput.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/:id/io/output", GetOutput.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/all", com.gamedash.daemon.api.server.route.routes.process.GetAll.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id", Get.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/process/:id", Get.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id/exists", com.gamedash.daemon.api.server.route.routes.process.Exists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/process/:id/resource/limit", LimitResources.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id/children", GetChildren.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/:id/resource/usage", GetResourceUsage.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/group/zip", Zip.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/realpath", GetRealPath.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/group/exists", com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Exists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/group/copy", com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Copy.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file", Write.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/isdirectory", IsDirectory.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/checksum/md5", MD5Checksum.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/checksum/sha1", SHA1Checksum.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/copy", Copy.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file", com.gamedash.daemon.api.server.route.routes.fileSystem.file.Create.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/file", Delete.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/download", Download.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/download/async", DownloadAsync.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/download/session/:session_id", GetDownloadSession.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/exists", Exists.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/move", com.gamedash.daemon.api.server.route.routes.fileSystem.file.Move.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file", Read.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/properties", GetProperties.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/size", GetSize.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file/group/executable", MakeExecutable.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/zip/size", GetZipSize.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/unzip", Unzip.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file", Write.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/upload/session", CreateSession.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/file/upload/session/:session_id", DeleteSession.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/upload/session/:session_id/exists", SessionExists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/upload/session/:session_id/chunk/:chunk_id/write", "multipart/form-data", WriteChunk.class, new JsonResponseTransformer()).before((request, response) -> {
            request.getRaw().setAttribute("org.eclipse.jetty.multipartConfig", new MultipartConfigElement(""));
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/upload/session/:session_id", GetSession.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file/append", Append.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/copy", com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Copy.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/directory", com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Create.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/file/directory", com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Delete.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/filesystem/file/directory/move", Move.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/directory/size", com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.GetSize.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/directory/contents", GetContents.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/directory/contents/walk", Walk.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/network/port/all", com.gamedash.daemon.api.server.route.routes.network.port.GetAll.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/network/port/:number", com.gamedash.daemon.api.server.route.routes.network.port.Get.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/system/user/:name", com.gamedash.daemon.api.server.route.routes.system.user.Create.class);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/system/user/:name", com.gamedash.daemon.api.server.route.routes.system.user.Delete.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/system/user/:name/exists", com.gamedash.daemon.api.server.route.routes.system.user.Exists.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/system/user/:name/authentication/password", SetPassword.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/system/user/:name/filesystem/file/home", SetHomeDirectory.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/system/user/:name/filesystem/file/permission/assign", AssignPermissions.class);
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/filesystem/file/hotlink/update/all", UpdateAll.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/hotlink/:id/serve", Serve.class);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/file/hotlink/:id/serve/*", Serve.class);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/remote/user/:user_name/session/all", GetAllSessionsForUser.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/filesystem/remote/user/session/all", GetAllSessions.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/filesystem/remote/user/:user_name/session", DisconnectSession.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/packagemanager/:name/install", InstallPackage.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/packagemanager/:name/uninstall", UninstallPackage.class).before(Authentication::ensureAuthenticated);
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/operatingSystem/linux/release", GetRelease.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/docker/container/all", GetContainers.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/docker/container/running", GetRunningContainers.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/docker/container", CreateContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.delete, "/docker/container/:container_id", RemoveContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/docker/container/:container_id/start", StartContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/docker/container/:container_id/stop", StopContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/docker/container/:container_id/kill", KillContainer.class, new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
    }
}

