/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.helpers.docker;

import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.DockerContainerAlreadyRunningException;
import com.gamedash.daemon.docker.container.DockerContainerNotFoundException;
import com.gamedash.daemon.docker.container.DockerContainerNotRunningException;

public class DockerContainerHelpers {
    private static Docker docker = Docker.getInstance();

    public static void ensureExists(String id) throws Exception {
        if (!docker.getContainers().exists(id)) {
            throw new DockerContainerNotFoundException("Docker container not found");
        }
    }

    public static void ensureIsRunning(String id) throws Exception {
        DockerContainer container = docker.getContainers().get(id);
        if (!container.isRunning()) {
            throw new DockerContainerNotRunningException("Docker container not running");
        }
    }

    public static void ensureIsNotRunning(String id) throws Exception {
        DockerContainer container = docker.getContainers().get(id);
        if (container.isRunning()) {
            throw new DockerContainerAlreadyRunningException("Docker container is already running");
        }
    }
}

