/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server;

import com.gamedash.daemon.api.server.ApiServerKeyStore;
import com.gamedash.daemon.api.server.ErrorBody;
import com.gamedash.daemon.api.server.ExceptionHandler;
import com.gamedash.daemon.api.server.authentication.NotAuthenticatedException;
import com.gamedash.daemon.api.server.route.Routes;
import com.gamedash.daemon.api.server.route.manager.RoutesManager;
import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.network.Network;
import com.gamedash.daemon.fileSystem.file.FileAlreadyExistsException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessionNotFoundException;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUserNotFoundException;
import com.gamedash.daemon.network.port.PortDoesNotExistException;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.system.user.SystemUserNotFoundException;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Service;

public class ApiServer {
    private static final Logger logger = LoggerFactory.getLogger(ApiServer.class);
    private static final List<ApiServer> instances = new ArrayList<ApiServer>();
    private final Gson gson = new Gson();
    private final Routes routes = new Routes(this);
    private final RoutesManager routesManager = new RoutesManager(this);
    private Boolean isRunning = false;
    private String ipAddress = Network.getIp().getHostAddress();
    private Service service;
    private int port;
    private ApiServerKeyStore keyStore;

    public void start() {
        if (this.isRunning().booleanValue()) {
            return;
        }
        this.setIsRunning(true);
        try {
            this.service = Service.ignite();
            this.getService().ipAddress(this.getIpAddress());
            this.getService().port(this.getPort());
            if (this.getKeyStore() != null) {
                ApiServerKeyStore keyStore = this.getKeyStore();
                this.getService().secure(keyStore.getFile().getAbsolutePath(), keyStore.getPassword(), null, null);
                logger.info("TLS enabled");
            }
            this.createExceptionHandler(Exception.class).register();
            this.createExceptionHandler(NotAuthenticatedException.class, 403).register();
            this.createExceptionHandler(FileNotFoundException.class, 404).register();
            this.createExceptionHandler(ProcessNotFoundException.class, 404).register();
            this.createExceptionHandler(ChildProcessNotFoundException.class, 404).register();
            this.createExceptionHandler(PortDoesNotExistException.class, 404).register();
            this.createExceptionHandler(ChildProcessNotRunningException.class, 404).register();
            this.createExceptionHandler(FileAlreadyExistsException.class, 409).register();
            this.createExceptionHandler(FileDownloaderSessionNotFoundException.class, 404).register();
            this.createExceptionHandler(SystemUserNotFoundException.class, 404).register();
            this.createExceptionHandler(RemoteFileSystemUserNotFoundException.class, 404).register();
            this.getService().before((request, response) -> {
                logger.debug(request.ip() + " " + request.requestMethod() + " " + request.uri());
                if (DevelopmentMode.isEnabled()) {
                    logger.debug("Incoming request from " + request.ip() + " for " + request.requestMethod() + " " + request.uri(), (Object)"api.server");
                }
            });
            this.getService().afterAfter((request, response) -> response.header("Server", "GameDash Daemon"));
            this.getService().notFound((request, response) -> {
                response.type("application/json");
                return this.gson.toJson(new ErrorBody("Invalid route"));
            });
            this.routes.register();
            this.getService().awaitInitialization();
            logger.info("Listening on port " + this.getPort());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.setIsRunning(false);
        }
    }

    public void stop() {
        if (this.isRunning().booleanValue()) {
            this.getService().stop();
            this.getService().awaitStop();
        }
    }

    public Boolean isRunning() {
        return this.isRunning;
    }

    public void setIsRunning(Boolean isRunning) {
        this.isRunning = isRunning;
    }

    public Service getService() {
        return this.service;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ApiServerKeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(ApiServerKeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public RoutesManager getRoutesManager() {
        return this.routesManager;
    }

    private <T extends Exception> ExceptionHandler<T> createExceptionHandler(Class<T> exceptionClass, int code) {
        return new ExceptionHandler<T>(this, exceptionClass, code);
    }

    private <T extends Exception> ExceptionHandler<T> createExceptionHandler(Class<T> exceptionClass) {
        return new ExceptionHandler<T>(this, exceptionClass, 400);
    }

    public static ApiServer createInstance() {
        ApiServer instance = new ApiServer();
        instances.add(instance);
        return instance;
    }

    public static List<ApiServer> getInstances() {
        return instances;
    }
}

