/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.Main;
import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.ApiServerKeyStore;
import com.gamedash.daemon.common.api.client.ApiClientConfig;
import com.gamedash.daemon.common.api.client.ApiClientConfigValidationResult;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.common.helpers.fileSystem.FileSystemHelpers;
import com.gamedash.daemon.common.license.Licenses;
import com.gamedash.daemon.common.network.Network;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.Dependency;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlinks;
import com.gamedash.daemon.fileSystem.remote.host.RemoteFileSystemHosts;
import com.gamedash.daemon.license.License;
import com.gamedash.daemon.license.LicenseValidation;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.process.childProcess.crash.GlobalCrashManager;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.Processors;
import com.gamedash.daemon.system.hardware.processor.governor.ProcessorGovernors;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import me.tongfei.progressbar.ProgressBar;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Init {
    private static final Logger logger = LoggerFactory.getLogger(Init.class);

    public static void initDependencies() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (Dependency dependency : Dependencies.getAll()) {
            if (dependency.isInstalled() || !dependency.isAvailable()) continue;
            Thread thread = new Thread(() -> {
                try (ProgressBar progressBar = new ProgressBar("Installing " + dependency.getName() + "...", 100L);){
                    dependency.getInstallManager().onInstallProgress(progress -> {
                        progressBar.stepTo(Double.valueOf(Math.ceil(progress.getPercentage())).longValue());
                        if (progress.getMessage() != null) {
                            progressBar.setExtraMessage(progress.getMessage());
                        }
                    });
                    dependency.getInstallManager().install();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            });
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.start();
            thread.join();
        }
    }

    public static void initNetwork() throws UnknownHostException {
        if (Application.args.ip != null) {
            Network.setIp(InetAddress.getByName(Application.args.ip));
        }
        Application.logger.info("Binding to IP " + Network.getIp().getHostAddress());
    }

    public static void initConfig() throws IOException {
        Config.setDefaultFile(Config.getFile("daemon.properties"));
        Application.logger.info("Using " + Config.getDefaultFile().toFile().getPath() + " as default config file");
    }

    public static void initFileSystem() {
        if (FileSystem.getRootDirectory() == null) {
            FileSystem.setRootDirectory(FileSystemHelpers.getOwnDirectory(Main.class));
        }
        Application.logger.info("Root directory set to " + FileSystem.getRootDirectory().getPath());
    }

    public static void initWindows() throws Exception {
        WindowsBridge.install();
    }

    public static void initApiClient() throws Exception {
        ApiClientConfigValidationResult apiClientConfigValidationResult;
        if (!Config.fileExists("daemon.properties")) {
            throw new ConfigException("daemon.properties does not exist");
        }
        if (Application.args.apiClientDomain != null) {
            ApiClientConfig.setDomain(Application.args.apiClientDomain);
        }
        if (Application.args.apiClientVersion != null) {
            ApiClientConfig.setVersion(Application.args.apiClientVersion);
        }
        if (!(apiClientConfigValidationResult = ApiClientConfig.validate()).isValid()) {
            throw new RuntimeException(apiClientConfigValidationResult.getMessage() != null ? apiClientConfigValidationResult.getMessage() : "Invalid API client config");
        }
    }

    public static void initKeyStore() throws Exception {
        if (KeyStore.hasFile().booleanValue()) {
            if (!KeyStore.getFile().exists()) {
                throw new RuntimeException("Keystore file does not exist");
            }
            if (!KeyStore.hasPassword()) {
                throw new RuntimeException("Keystore password is not set");
            }
            if (KeyStore.isSelfSigned().booleanValue()) {
                Application.logger.warn("Certificate is self signed");
            }
        }
    }

    public static void initServices() throws Exception {
        Init.initLicense();
        if (!Authentication.isAuthenticated()) {
            throw new Exception("Could not authenticate");
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        futures.add(threadPool.submit(Init::initHttpApiServer));
        futures.add(threadPool.submit(Init::initHttpsApiServer));
        futures.add(threadPool.submit(Init::initSshServer));
        futures.add(threadPool.submit(Init::initRemoteFileSystemHosts));
        futures.add(threadPool.submit(Init::initFileSystemHotlinks));
        futures.add(threadPool.submit(Init::initChildProcessGlobalCrashManager));
        futures.add(threadPool.submit(Init::initProcessorGovernors));
        threadPool.shutdown();
        threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            logger.debug(ExceptionUtils.getStackTrace(e));
            System.exit(1);
        }
    }

    private static void initLicense() throws Exception {
        String id = Licenses.getCurrent().getSystems().getCurrent().getId();
        logger.info("System ID " + id);
        License.validate();
        LicenseValidation.initPeriodicChecks();
    }

    private static Void initHttpApiServer() throws IOException {
        ApiServer httpInstance = ApiServer.createInstance();
        httpInstance.setPort(Config.getFile("daemon.properties").valueExists("api.server.http.port") ? Config.getFile("daemon.properties").getValue("api.server.http.port", Integer.class) : 2145);
        httpInstance.start();
        return null;
    }

    private static Void initHttpsApiServer() throws IOException, KeyStoreException {
        if (KeyStore.hasFile().booleanValue() && KeyStore.hasPassword()) {
            ApiServer httpsInstance = ApiServer.createInstance();
            httpsInstance.setKeyStore(new ApiServerKeyStore(KeyStore.getFile(), KeyStore.getPassword()));
            httpsInstance.setPort(Config.getFile("daemon.properties").valueExists("api.server.https.port") ? Config.getFile("daemon.properties").getValue("api.server.https.port", Integer.class) : 2147);
            httpsInstance.start();
        }
        return null;
    }

    private static Void initProcessorGovernors() {
        if (!ProcessorGovernors.isAvailable()) {
            logger.warn("Processor governors are not available");
            return null;
        }
        try {
            List<Processor> processors = Processors.getAll();
            for (Processor processor : processors) {
                processor.enforcePerformanceGovernor();
            }
            logger.info("Enforced performance governor for all " + processors.size() + " processors");
        }
        catch (Exception e) {
            logger.error("Could not enforce performance governor for processors " + e.getMessage());
        }
        return null;
    }

    private static Void initSshServer() throws IOException {
        return null;
    }

    private static Void initChildProcessGlobalCrashManager() {
        GlobalCrashManager.initializeWorker();
        return null;
    }

    private static Void initRemoteFileSystemHosts() throws Exception {
        RemoteFileSystemHosts.start();
        return null;
    }

    private static Void initFileSystemHotlinks() throws Exception {
        Hotlinks.update();
        return null;
    }
}

