/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.platform.unix.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.platform.NativeBridge;
import org.icmp4j.platform.unix.jna.IcmpLibrary;
import org.icmp4j.platform.unix.jna.LibraryUtil;

public class UnixJnaNativeBridge
extends NativeBridge {
    @Override
    public void initialize() {
        LibraryUtil.initialize();
        IcmpLibrary icmpLibrary = LibraryUtil.getIcmpLibrary();
        PointerByReference ptrRef = new PointerByReference();
        icmpLibrary.icmp4j_exist(ptrRef);
        Pointer p = ptrRef.getValue();
        String version = p.getString(0L);
        this.logger.info("using icmp4jJNA v " + version);
        icmpLibrary.icmp4j_exist_free(p);
    }

    @Override
    public IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        IcmpLibrary icmpLibrary = LibraryUtil.getIcmpLibrary();
        IcmpLibrary.Icmp4jStruct.ByReference ref = new IcmpLibrary.Icmp4jStruct.ByReference();
        ref.host = request.getHost();
        ref.ttl = request.getTtl();
        ref.packetSize = request.getPacketSize();
        ref.timeOut = new NativeLong(request.getTimeout());
        long icmpSendEchoStartNanoTime = System.nanoTime();
        IcmpPingResponse response = new IcmpPingResponse();
        icmpLibrary.icmp4j_start(ref);
        long icmpSendEchoNanoDuration = System.nanoTime() - icmpSendEchoStartNanoTime;
        long icmpSendEchoDuration = icmpSendEchoNanoDuration / 1000L / 1000L;
        response.setSuccessFlag(ref.retCode == 1);
        response.setTimeoutFlag(ref.hasTimeout == 1);
        response.setErrorMessage(ref.errorMsg);
        response.setHost(ref.address);
        response.setSize(ref.bytes);
        response.setRtt(ref.rtt);
        response.setTtl(ref.ttl);
        icmpLibrary.icmp4j_free(ref);
        response.setDuration(icmpSendEchoDuration);
        return response;
    }
}

