/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.platform.java;

import java.net.InetAddress;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.IcmpPingUtil;
import org.icmp4j.platform.NativeBridge;

public class JavaNativeBridge
extends NativeBridge {
    @Override
    public IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        try {
            boolean timeoutFlag;
            String host = request.getHost();
            InetAddress address = InetAddress.getByName(host);
            int timeout = new Long(request.getTimeout()).intValue();
            long pingStartNanoTime = System.nanoTime();
            long icmpSendEchoStartTime = System.currentTimeMillis();
            boolean successFlag = address.isReachable(timeout);
            long icmpSendEchoDuration = System.currentTimeMillis() - icmpSendEchoStartTime;
            long rttNanos = System.nanoTime() - pingStartNanoTime;
            int rtt = new Long(rttNanos / 1000000L).intValue();
            boolean bl = timeoutFlag = icmpSendEchoDuration >= (long)timeout;
            if (timeoutFlag) {
                return IcmpPingUtil.createTimeoutIcmpPingResponse(icmpSendEchoDuration);
            }
            IcmpPingResponse response = new IcmpPingResponse();
            response.setHost(null);
            response.setErrorMessage(null);
            response.setRtt(rtt);
            response.setSize(0);
            response.setSuccessFlag(successFlag);
            response.setTtl(0);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

