/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class ChannelSession
extends AbstractClientChannel {
    public static final String INPUT_STREAM_PUMP_CHUNK_SIZE = "stdin-pump-chunk-size";
    public static final int DEFAULT_INPUT_STREAM_PUMP_CHUNK_SIZE = 1024;
    private CloseableExecutorService pumperService;
    private Future<?> pumper;

    public ChannelSession() {
        super("session");
    }

    @Override
    protected void doOpen() throws IOException {
        if (ClientChannel.Streaming.Async.equals((Object)this.streaming)) {
            this.asyncIn = new ChannelAsyncOutputStream(this, 94){

                @Override
                protected CloseFuture doCloseGracefully() {
                    try {
                        ChannelSession.this.sendEof();
                    }
                    catch (IOException e) {
                        Session session = ChannelSession.this.getSession();
                        session.exceptionCaught(e);
                    }
                    return super.doCloseGracefully();
                }
            };
            this.asyncOut = new ChannelAsyncInputStream(this);
            this.asyncErr = new ChannelAsyncInputStream(this);
        } else {
            ChannelPipedOutputStream pos;
            ChannelPipedInputStream pis;
            this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            Window wLocal = this.getLocalWindow();
            if (this.out == null) {
                pis = new ChannelPipedInputStream(this, wLocal);
                pos = new ChannelPipedOutputStream(pis);
                this.out = pos;
                this.invertedOut = pis;
            }
            if (this.err == null) {
                pis = new ChannelPipedInputStream(this, wLocal);
                pos = new ChannelPipedOutputStream(pis);
                this.err = pos;
                this.invertedErr = pis;
            }
            if (this.in != null) {
                CloseableExecutorService service = this.getExecutorService();
                this.pumperService = service == null ? ThreadUtils.newSingleThreadExecutor("ClientInputStreamPump[" + this + "]") : ThreadUtils.noClose(service);
                this.pumper = this.pumperService.submit(this::pumpInputStream);
            }
        }
    }

    @Override
    protected RequestHandler.Result handleInternalRequest(String req, boolean wantReply, Buffer buffer) throws IOException {
        switch (req) {
            case "xon-xoff": {
                return this.handleXonXoff(buffer, wantReply);
            }
        }
        return super.handleInternalRequest(req, wantReply, buffer);
    }

    protected RequestHandler.Result handleXonXoff(Buffer buffer, boolean wantReply) throws IOException {
        boolean clientCanDo = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleXonXoff({})[want-reply={}] client-can-do={}", this, wantReply, clientCanDo);
        }
        return RequestHandler.Result.ReplySuccess;
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        if (this.pumper != null && this.pumperService != null && !this.pumperService.isShutdown()) {
            try {
                if (!this.pumper.isDone()) {
                    this.pumper.cancel(true);
                }
                this.pumperService.shutdownNow();
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doCloseImmediately({}) failed {} to shutdown stream pumper: {}", this, e.getClass().getSimpleName(), e.getMessage());
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("doCloseImmediately(" + this + ") stream pumper shutdown error details", e);
                }
            }
            finally {
                this.pumper = null;
                this.pumperService = null;
            }
        }
    }

    protected void pumpInputStream() {
        block8: {
            try {
                Session session = this.getSession();
                Window wRemote = this.getRemoteWindow();
                long packetSize = wRemote.getPacketSize();
                ValidateUtils.checkTrue(packetSize > 0L && packetSize < Integer.MAX_VALUE, "Invalid remote packet size int boundary: %d", packetSize);
                byte[] buffer = new byte[(int)packetSize];
                int maxChunkSize = PropertyResolverUtils.getIntProperty(session, INPUT_STREAM_PUMP_CHUNK_SIZE, 1024);
                maxChunkSize = Math.max(maxChunkSize, 1024);
                while (!this.closeFuture.isClosed()) {
                    int len = this.securedRead(this.in, maxChunkSize, buffer, 0, buffer.length);
                    if (len < 0) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("pumpInputStream({}) EOF signalled", (Object)this);
                        }
                        this.sendEof();
                        return;
                    }
                    session.resetIdleTimeout();
                    if (len <= 0) continue;
                    this.invertedIn.write(buffer, 0, len);
                    this.invertedIn.flush();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("pumpInputStream({}) close future closed", (Object)this);
                }
            }
            catch (Exception e) {
                if (this.isClosing()) break block8;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("pumpInputStream({}) Caught {} : {}", this, e.getClass().getSimpleName(), e.getMessage());
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("pumpInputStream(" + this + ") caught exception details", e);
                }
                this.close(false);
            }
        }
    }

    protected int securedRead(InputStream in, int maxChunkSize, byte[] buf, int off, int len) throws IOException {
        int availLen;
        int n = 0;
        do {
            int nread;
            if ((nread = in.read(buf, off + n, Math.min(maxChunkSize, len - n))) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((availLen = in.available()) > 0);
        return n;
    }
}

