/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.ssl.SslConfiguration;

public class PROT
extends AbstractCommand {
    private SslConfiguration getSslConfiguration(FtpIoSession session) {
        DataConnectionConfiguration dataCfg = session.getListener().getDataConnectionConfiguration();
        SslConfiguration configuration = dataCfg.getSslConfiguration();
        if (configuration == null) {
            configuration = session.getListener().getSslConfiguration();
        }
        return configuration;
    }

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String arg = request.getArgument();
        if (arg == null) {
            session.write(LocalizedFtpReply.translate(session, request, context, 501, "PROT", null));
            return;
        }
        arg = arg.toUpperCase();
        ServerDataConnectionFactory dcon = session.getDataConnection();
        if (arg.equals("C")) {
            dcon.setSecure(false);
            session.write(LocalizedFtpReply.translate(session, request, context, 200, "PROT", null));
        } else if (arg.equals("P")) {
            if (this.getSslConfiguration(session) == null) {
                session.write(LocalizedFtpReply.translate(session, request, context, 431, "PROT", null));
            } else {
                dcon.setSecure(true);
                session.write(LocalizedFtpReply.translate(session, request, context, 200, "PROT", null));
            }
        } else {
            session.write(LocalizedFtpReply.translate(session, request, context, 504, "PROT", null));
        }
    }
}

