/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.hardware.processor.governor;

import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.governor.GovernorAnnotation;
import com.gamedash.daemon.system.hardware.processor.governor.IGovernor;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Governor {
    private static final Logger logger = LoggerFactory.getLogger(Governor.class);
    private Class<? extends IGovernor> governorClass;
    private IGovernor instance;

    public Governor(Class<? extends IGovernor> governorClass) {
        this.governorClass = governorClass;
    }

    public String getName() {
        GovernorAnnotation annotation = this.getAnnotation();
        return annotation != null ? annotation.name() : null;
    }

    public void enforce(Processor processor) throws Exception {
        this.getInstance().enforce(processor);
    }

    public Class<? extends IGovernor> getDependencyClass() {
        return this.governorClass;
    }

    public IGovernor getInstance() throws Exception {
        if (this.instance == null) {
            this.instance = this.getDependencyClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.instance;
    }

    private GovernorAnnotation getAnnotation() {
        for (Annotation annotation : this.getDependencyClass().getAnnotations()) {
            if (!(annotation instanceof GovernorAnnotation)) continue;
            return (GovernorAnnotation)annotation;
        }
        return null;
    }
}

