/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.windows;

import com.gamedash.daemon.network.port.Port;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcess;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcesses;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.platform.windows.WindowsProcess;
import com.gamedash.daemon.singleton.SingletonList;
import java.util.ArrayList;
import java.util.List;

public class WindowsProcesses {
    private static final SingletonList<WindowsProcess> processes = new SingletonList<WindowsProcess>(){

        @Override
        public boolean compare(Object a, Object b) {
            return a instanceof WindowsProcess && b instanceof Port && ((WindowsProcess)a).getId() == ((WindowsProcess)b).getId();
        }
    };

    public static List<WindowsProcess> getAll() throws Exception {
        ArrayList<WindowsProcess> processes = new ArrayList<WindowsProcess>();
        for (WindowsPlatformProcess windowsBridgeProcess : WindowsPlatformProcesses.getAll()) {
            processes.add(new WindowsProcess(windowsBridgeProcess.getId()));
        }
        return processes;
    }

    public static WindowsProcess get(int id) {
        WindowsProcess process = processes.find(_process -> _process.getId() == id);
        if (process == null) {
            process = new WindowsProcess(id);
            processes.add(process);
        }
        return process;
    }

    public static boolean exists(int id) throws Exception {
        return WindowsPlatformProcesses.exists(id);
    }

    public static void stop(WindowsProcess[] processes) throws Exception {
        for (WindowsProcess process : processes) {
            process.stop();
        }
    }

    public static void kill(WindowsProcess[] processes) throws Exception {
        for (WindowsProcess process : processes) {
            process.kill();
        }
    }

    public static WindowsProcess[] filter(IProcess[] processes) {
        ArrayList<WindowsProcess> filtered = new ArrayList<WindowsProcess>();
        for (IProcess process : processes) {
            if (!(process instanceof WindowsProcess)) continue;
            filtered.add((WindowsProcess)process);
        }
        return (WindowsProcess[])filtered.toArray(WindowsProcess[]::new);
    }
}

