/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.IProcessOnExitCallback;
import com.gamedash.daemon.process.OnExitListener;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.resource.limit.DiskResourceLimit;
import com.gamedash.daemon.process.resource.limit.IResourceLimitEnforcementManager;
import com.gamedash.daemon.process.resource.limit.RAMResourceLimit;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.Processors;
import java.util.List;

public abstract class AbstractProcess
implements IProcess {
    protected OnExitListener onExitListener = new OnExitListener();
    private final int id;
    private boolean exited = false;
    private CPUResourceLimit cpuResourceLimit;
    private RAMResourceLimit ramResourceLimit;
    private DiskResourceLimit diskResourceLimit;
    private IResourceLimitEnforcementManager resourceLimitEnforcementManager;

    public AbstractProcess(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void onExit(IProcessOnExitCallback callback) {
        this.onExitListener.addCallback(callback);
    }

    @Override
    public void invokeOnExit() throws Exception {
        this.destroyResourceLimits();
    }

    @Override
    public boolean hasExited() {
        return this.exited;
    }

    private void setHasExited(boolean exited) {
        this.exited = exited;
    }

    @Override
    public boolean isSelf() {
        return Processes.processIsSelf(this);
    }

    public CPUResourceLimit getCPUResourceLimit() {
        return this.cpuResourceLimit;
    }

    @Override
    public void setCPUResourceLimit(CPUResourceLimit cpu) {
        this.cpuResourceLimit = cpu;
    }

    public RAMResourceLimit getRAMResourceLimit() {
        return this.ramResourceLimit;
    }

    @Override
    public void setRAMResourceLimit(RAMResourceLimit ram) {
        this.ramResourceLimit = ram;
    }

    public DiskResourceLimit getDiskResourceLimit() {
        return this.diskResourceLimit;
    }

    @Override
    public void setDiskResourceLimit(DiskResourceLimit disk) {
        this.diskResourceLimit = disk;
    }

    @Override
    public void startEnforcingResourceLimits() throws Exception {
        IResourceLimitEnforcementManager manager = this.getResourceLimitEnforcementManager();
        if (!manager.isRunning()) {
            manager.start();
        }
    }

    @Override
    public boolean isEnforcingResourceLimits() {
        return this.getResourceLimitEnforcementManager().isRunning();
    }

    @Override
    public void ensureIsEnforcingResourceLimits() throws Exception {
        if (!this.isEnforcingResourceLimits()) {
            this.startEnforcingResourceLimits();
        }
    }

    @Override
    public void destroyResourceLimits() throws Exception {
        IResourceLimitEnforcementManager manager = this.getResourceLimitEnforcementManager();
        if (manager.isRunning()) {
            manager.stop();
        }
    }

    protected void ensureAffinityProcessorsIsInRange(List<Processor> processors) {
        int processorCount = Processors.count();
        for (Processor processor : processors) {
            if (processor.getId() >= 0 && processor.getId() <= processorCount) continue;
            throw new ProcessException("Affinity processor " + processor.getId() + " is out of range");
        }
    }

    @Override
    public IResourceLimitEnforcementManager getResourceLimitEnforcementManager() {
        if (this.resourceLimitEnforcementManager == null) {
            this.resourceLimitEnforcementManager = this.createResourceLimitEnforcementManager();
        }
        return this.resourceLimitEnforcementManager;
    }

    protected abstract IResourceLimitEnforcementManager createResourceLimitEnforcementManager();

    public boolean equals(Object value) {
        return value instanceof IProcess && ((IProcess)value).getId() == this.getId();
    }
}

