/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.crash.report;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.crash.report.CrashReportProcessPropagatingException;

public class CrashReport {
    private ChildProcess childProcess;
    private int retryCount = 0;

    public CrashReport(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public void send() throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/process/childprocess/" + this.childProcess.getId() + "/crash/report");
        query.getResponseErrorHandlerManager().registerHandler(response -> {
            if (response instanceof QueryResponse && ((QueryResponse)response).getErrorCode().equals("PROCESS_PROPAGATING")) {
                throw new CrashReportProcessPropagatingException("Process is propagating");
            }
        });
        query.post();
    }
}

