/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.system.hardware.processor;

import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorConservativeGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorOnDemandGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorPerformanceGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorPowersaveGovernor;
import com.gamedash.daemon.platform.linux.system.hardware.processor.LinuxProcessorUserspaceGovernor;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.governor.Governor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LinuxProcessorGovernors {
    private static List<Governor> governors = new ArrayList<Governor>(){
        {
            this.add(new Governor(LinuxProcessorConservativeGovernor.class));
            this.add(new Governor(LinuxProcessorOnDemandGovernor.class));
            this.add(new Governor(LinuxProcessorUserspaceGovernor.class));
            this.add(new Governor(LinuxProcessorPowersaveGovernor.class));
            this.add(new Governor(LinuxProcessorPerformanceGovernor.class));
        }
    };

    public static List<Governor> getAvailable(Processor processor) throws IOException {
        String contents = Files.readString(Paths.get("/sys/devices/system/cpu/cpu" + processor.getId() + "/cpufreq/scaling_available_governors", new String[0]), StandardCharsets.UTF_8);
        return Arrays.stream(contents.split("\\\\s+")).map(LinuxProcessorGovernors::get).collect(Collectors.toList());
    }

    public static Governor get(String name) {
        for (Governor governor : governors) {
            if (!governor.getName().equals(name)) continue;
            return governor;
        }
        return null;
    }

    public static Governor getForProcessor(Processor processor) throws IOException {
        String name = Files.readString(Paths.get("/sys/devices/system/cpu/cpu" + processor.getId() + "/cpufreq/scaling_governor", new String[0]));
        return LinuxProcessorGovernors.get(name);
    }

    public static Governor getPerformanceGovernor() throws Exception {
        return LinuxProcessorGovernors.get("performance");
    }
}

